/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.infomodel.validation;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModelPackage;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelPackage;
import org.eclipse.vorto.editor.datatype.validation.ValidatorUtils;
import org.eclipse.vorto.editor.infomodel.validation.AbstractInformationModelValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;

public class InformationModelValidator
extends AbstractInformationModelValidator {
    @Check
    public void checkInformationModelName(InformationModel model) {
        String name = model.getName();
        boolean _isCamelCasedName = this.isCamelCasedName(name);
        if (_isCamelCasedName) {
            this.error("Information model name must begin with a capital letter", (EObject)model, (EStructuralFeature)ModelPackage.Literals.MODEL__NAME);
        }
    }

    @Check
    public void checkDuplicateFunctionBlock(InformationModel informationModel) {
        HashSet<String> fbNamesSet = new HashSet<String>();
        EList functionblockProperties = informationModel.getProperties();
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray((Object)functionblockProperties, Object.class)).length) {
            boolean _not;
            FunctionblockProperty functionblockProperty = (FunctionblockProperty)functionblockProperties.get(i);
            boolean _add = fbNamesSet.add(functionblockProperty.getName());
            boolean bl = _not = !_add;
            if (_not) {
                this.error("Function Block is already defined", (EObject)informationModel, (EStructuralFeature)InformationModelPackage.Literals.FUNCTIONBLOCK_PROPERTY__NAME);
            }
            ++i;
        }
    }

    @Check
    public void checkFunctionBlockIsImported(FunctionblockProperty property) {
        EObject _parentOfType = ValidatorUtils.getParentOfType((EObject)property, InformationModel.class);
        InformationModel topParent = (InformationModel)_parentOfType;
        if (topParent != null && !ValidatorUtils.isTypeInReferences((Model)property.getType(), (EList)topParent.getReferences())) {
            this.error("This Function Block has not yet been imported.", (EObject)property, (EStructuralFeature)InformationModelPackage.Literals.FUNCTIONBLOCK_PROPERTY__TYPE);
        }
    }

    @Check
    public void checkStatusExtendOverriddenProperties(InformationModel informationModel) {
        ArrayList validatedConstraints = new ArrayList();
        EList _properties = informationModel.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            boolean _tripleNotEquals;
            FunctionBlock _extendedFunctionBlock = fbProperty.getExtendedFunctionBlock();
            boolean bl = _tripleNotEquals = _extendedFunctionBlock != null;
            if (!_tripleNotEquals) continue;
            FunctionBlock baseFb = fbProperty.getType().getFunctionblock();
            FunctionBlock extendedFb = fbProperty.getExtendedFunctionBlock();
            this.validateOverriddenProperties(baseFb.getStatus().getProperties(), extendedFb.getStatus().getProperties(), validatedConstraints);
        }
    }

    @Check
    public void checkConfigurationExtendOverriddenProperties(InformationModel informationModel) {
        ArrayList validatedConstraints = new ArrayList();
        EList _properties = informationModel.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            boolean _tripleNotEquals;
            FunctionBlock _extendedFunctionBlock = fbProperty.getExtendedFunctionBlock();
            boolean bl = _tripleNotEquals = _extendedFunctionBlock != null;
            if (!_tripleNotEquals) continue;
            FunctionBlock baseFb = fbProperty.getType().getFunctionblock();
            FunctionBlock extendedFb = fbProperty.getExtendedFunctionBlock();
            this.validateOverriddenProperties(baseFb.getConfiguration().getProperties(), extendedFb.getConfiguration().getProperties(), validatedConstraints);
        }
    }

    @Check
    public void checkFaultExtendOverriddenProperties(InformationModel informationModel) {
        ArrayList validatedConstraints = new ArrayList();
        EList _properties = informationModel.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            boolean _tripleNotEquals;
            FunctionBlock _extendedFunctionBlock = fbProperty.getExtendedFunctionBlock();
            boolean bl = _tripleNotEquals = _extendedFunctionBlock != null;
            if (!_tripleNotEquals) continue;
            FunctionBlock baseFb = fbProperty.getType().getFunctionblock();
            FunctionBlock extendedFb = fbProperty.getExtendedFunctionBlock();
            this.validateOverriddenProperties(baseFb.getFault().getProperties(), extendedFb.getFault().getProperties(), validatedConstraints);
        }
    }

    @Check
    public void checkEventsExtendOverriddenProperties(InformationModel informationModel) {
        EList _properties = informationModel.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            boolean _tripleNotEquals;
            FunctionBlock _extendedFunctionBlock = fbProperty.getExtendedFunctionBlock();
            boolean bl = _tripleNotEquals = _extendedFunctionBlock != null;
            if (!_tripleNotEquals) continue;
            FunctionBlock baseFb = fbProperty.getType().getFunctionblock();
            FunctionBlock extendedFb = fbProperty.getExtendedFunctionBlock();
            this.validateOverriddenEvents(baseFb.getEvents(), extendedFb.getEvents());
        }
    }

    @Check
    public void checkOverrideOperationType(InformationModel informationModel) {
        EList _properties = informationModel.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            boolean _tripleNotEquals;
            FunctionBlock _extendedFunctionBlock = fbProperty.getExtendedFunctionBlock();
            boolean bl = _tripleNotEquals = _extendedFunctionBlock != null;
            if (!_tripleNotEquals) continue;
            FunctionBlock baseFb = fbProperty.getType().getFunctionblock();
            FunctionBlock extendedFb = fbProperty.getExtendedFunctionBlock();
            this.validateOverriddenOperations(baseFb.getOperations(), extendedFb.getOperations());
        }
    }
}

