/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.mapping.tests.parser;

import java.io.IOException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.mapping.MappingPackage;
import org.eclipse.vorto.editor.mapping.MappingStandaloneSetup;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LWM2MMappingParseTest {
    private static final String EXAMPLES_DIRECTORY = "resources/org/eclipse/vorto/editor/mapping/tests/parser/examples/lwm2m/shared_models/";

    @Before
    public void setup() {
        MappingStandaloneSetup.doSetup();
    }

    @Test
    public void parseEntityMapping() throws IOException {
        MappingModel mappingModel = this.createMappingModel("LWM2MResourceEntity.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)4L, (long)rules.size());
    }

    @Test
    public void parseEnumMapping() throws IOException {
        MappingModel mappingModel = this.createMappingModel("LWM2MResourceEnum.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)4L, (long)rules.size());
    }

    @Test
    public void parseFunctionBlockMapping() throws IOException {
        MappingModel mappingModel = this.createMappingModel("LWM2MResourceComplete.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)3L, (long)rules.size());
    }

    @Test
    public void parseInformationModelMapping() throws IOException {
        MappingModel mappingModel = this.createMappingModel("LWM2MObjectType.mapping");
        EList rules = mappingModel.getRules();
        Assert.assertEquals((long)1L, (long)rules.size());
    }

    private MappingModel createMappingModel(String mappingFileName) throws IOException {
        ResourceSetImpl rset = new ResourceSetImpl();
        rset.getPackageRegistry().put((Object)"http://www.eclipse.org/vorto/metamodel/Mapping", (Object)MappingPackage.eINSTANCE);
        rset.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        Resource resource = rset.getResource(URI.createFileURI((String)(EXAMPLES_DIRECTORY + mappingFileName)), true);
        resource.load(null);
        MappingModel mappingModel = (MappingModel)resource.getContents().get(0);
        return mappingModel;
    }
}

