/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.service.bosch.auth;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class IM3AuthenticationProviderTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"IM3AuthenticationProvider.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/service/bosch/permissions");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".service.bosch.permissions;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.ArrayList;");
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.CompletableFuture;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.ExecutionException;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.TimeUnit;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.TimeoutException;");
        _builder.newLine();
        _builder.append((Object)"import java.util.function.Function;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import javax.annotation.PostConstruct;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.Logger;");
        _builder.newLine();
        _builder.append((Object)"import org.slf4j.LoggerFactory;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.authentication.AuthenticationProvider;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.authentication.BadCredentialsException;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.core.Authentication;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.core.AuthenticationException;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.core.GrantedAuthority;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.core.authority.SimpleGrantedAuthority;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.core.context.SecurityContextHolder;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.bosch.im.api2.Scope;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.im.api2.client.IClient;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.im.api2.client.IClientBuilder;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.im.api2.client.exception.server.AuthenticationDeniedException;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.im.api2.dto.AuthenticationDto;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.im.api2.dto.AuthorizationDto;");
        _builder.newLine();
        _builder.append((Object)"import com.bosch.im.api2.jwt.IAuthorizationToken;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class IM3AuthenticationProvider implements AuthenticationProvider {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Logger logger = LoggerFactory.getLogger(IM3AuthenticationProvider.class);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String serviceUrl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String clientId;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String clientSecret;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private int expireTimeInSeconds = 60 * 60 * 2;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private IClient client;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Function<AuthenticationDto, CompletableFuture<AuthorizationDto>> createAuthorization;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Function<AuthorizationDto, CompletableFuture<IAuthorizationToken>> parseAuthorization;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@PostConstruct");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private void init() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"logger.debug(\"ServiceUrl [\" + serviceUrl + \"] ClientID [\" + clientId + \"]\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"client = IClientBuilder.newInstance()");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".serviceUrl(serviceUrl)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".clientId(clientId)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".clientSecret(clientSecret)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".build();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"createAuthorization = (AuthenticationDto dto) -> client.authorize()");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".idToken(dto.getIdToken())");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".userTenantId(dto.getUserTid())");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".scopes(Scope.pn, Scope.rn)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".applications(\"Vorto\")");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".execute();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"parseAuthorization = (AuthorizationDto dto) -> client.parseToAuthorizationToken()");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".authorizationToken(dto.getAuthorizationToken())");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".execute();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Authentication authenticate(Authentication authentication) throws AuthenticationException {\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (!(authentication instanceof UsernamePasswordAuthenticationToken)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new BadCredentialsException(\"Cannot use the IM3 provider for this type of authentication\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken) authentication;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Credential credential = getCredential(token);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.debug(\"Logging IN user [\" + credential.tenant + \"\\\\\" + credential.username + \"]\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"UsernamePasswordAuthenticationToken authenticationToken = createAuthenticationRequest(credential)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".thenCompose(createAuthorization)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".thenCompose(parseAuthorization)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".thenApply(createToken(token, credential))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".get(30, TimeUnit.SECONDS);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"SecurityContextHolder.getContext().setAuthentication(authenticationToken);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.debug(\"Log-in successful for user [\" + credential.tenant + \"\\\\\" + credential.username + \"]\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return authenticationToken;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch(InterruptedException | ExecutionException authEx) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"Internal Server Error\", authEx);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(\"Internal server error while requesting IM permissions\", authEx);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (TimeoutException authEx) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"Credential Request to IM timed out.\", authEx);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(\"Credential Request Timed-out\", authEx);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (AuthenticationDeniedException authEx) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"logger.error(\"Wrong Credentials for user : \" + token.getName(), authEx);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new BadCredentialsException(\"Wrong Credentials\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Credential getCredential(UsernamePasswordAuthenticationToken token) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"assert(token != null);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"assert(token.getName() != null);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final String[] tenantAndUsername = token.getName().split(\"\\\\\\\\\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (tenantAndUsername.length != 2) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new BadCredentialsException(\"Either no tenant or no username\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new Credential(tenantAndUsername[0], tenantAndUsername[1], token.getCredentials().toString());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public CompletableFuture<AuthenticationDto> createAuthenticationRequest(Credential credential) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return client.authenticate()");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)".userTenantIdOrName(credential.tenant)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t  \t");
        _builder.append((Object)".userName(credential.username)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t  \t");
        _builder.append((Object)".password(credential.password)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t  \t");
        _builder.append((Object)".expiresIn(expireTimeInSeconds)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t  \t");
        _builder.append((Object)".execute();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private Function<IAuthorizationToken, UsernamePasswordAuthenticationToken> createToken(UsernamePasswordAuthenticationToken token, ");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"Credential credential) {");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"return (IAuthorizationToken authToken) -> {");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"if (authToken == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"throw new BadCredentialsException(\"Wrong Credentials\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();\t\t");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"authorities.add(new SimpleGrantedAuthority(\"ROLE_USER\"));");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"UsernamePasswordAuthenticationToken imToken = new UsernamePasswordAuthenticationToken(token.getPrincipal(),");
        _builder.newLine();
        _builder.append((Object)"    \t\t\t\t");
        _builder.append((Object)"credential.password, authorities);");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"imToken.setDetails(new IMUserInfo(credential.username, ");
        _builder.newLine();
        _builder.append((Object)"    \t\t\t\t           ");
        _builder.append((Object)"credential.password, ");
        _builder.newLine();
        _builder.append((Object)"    \t\t\t\t           ");
        _builder.append((Object)"credential.tenant, ");
        _builder.newLine();
        _builder.append((Object)"    \t\t\t\t           ");
        _builder.append((Object)"authToken));");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.newLine();
        _builder.append((Object)"    \t\t");
        _builder.append((Object)"return imToken;");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getServiceUrl() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return serviceUrl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setServiceUrl(String serviceUrl) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.serviceUrl = serviceUrl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getClientId() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return clientId;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setClientId(String clientId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.clientId = clientId;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getClientSecret() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return clientSecret;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setClientSecret(String clientSecret) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.clientSecret = clientSecret;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int getExpireTimeInSeconds() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return expireTimeInSeconds;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setExpireTimeInSeconds(int expireTimeInSeconds) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.expireTimeInSeconds = expireTimeInSeconds;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean supports(Class<?> authentication) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return authentication.equals(UsernamePasswordAuthenticationToken.class);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private class Credential {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"private String tenant;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"private String username;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"private String password;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public Credential(String tenant, String username, String password) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.tenant = tenant;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.username = username;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.password = password;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

