/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.aws.alexa.templates;

import com.google.common.base.Objects;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.aws.alexa.templates.AbstractAlexaTemplate;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class AlexaSkillLambdaTemplate
extends AbstractAlexaTemplate {
    public String getFileName(InformationModel context) {
        return "alexa-skillset-lambda.js";
    }

    public String getContent(InformationModel element, InvocationContext context) {
        Map _configurationProperties_2;
        String _orDefault_2;
        boolean _equalsIgnoreCase_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"'use strict';");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"var speechOutput;");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"var reprompt;");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"var welcomeOutput = \"Let's ask the ");
        String _name = element.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)". What do you want to know?\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Map _configurationProperties = context.getConfigurationProperties();
        String _orDefault = _configurationProperties.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase = _orDefault.equalsIgnoreCase("true");
        if (_equalsIgnoreCase) {
            _builder.append((Object)" ");
            _builder.append((Object)"var thingsApiToken = \"INSERT API TOKEN OF BOSCH IOT THINGS HERE\";");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"var thingId = ");
            Map _configurationProperties_1 = context.getConfigurationProperties();
            String _orDefault_1 = _configurationProperties_1.getOrDefault("thingId", "\"INSERT THING ID HERE\"");
            _builder.append((Object)_orDefault_1, " ");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"var username= \"INSERT USERNAME HERE\";");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"var password= \"INSERT PASSWORD HERE\";");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"var http = require('http');");
            _builder.newLine();
        }
        if (_equalsIgnoreCase_1 = (_orDefault_2 = (_configurationProperties_2 = context.getConfigurationProperties()).getOrDefault("awsiot", "false")).equalsIgnoreCase("true")) {
            _builder.append((Object)" ");
            _builder.append((Object)"var config = {");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"\t");
            _builder.append((Object)"\"thingName\": \"<PUT THING NAME HERE>\",");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"\t");
            _builder.append((Object)"\"endpointAddress\": \"<PUT YOUR ENDPOINT URL HERE>\"");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"var AWS = require('aws-sdk');");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"var iotdata = new AWS.IotData({endpoint: config.endpointAddress});");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"// --------------- Helpers that build all of the responses -----------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"function buildSpeechletResponse(title, output, repromptText, shouldEndSession) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"return {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"outputSpeech: {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"type: 'PlainText',");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"text: output,");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"},");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"card: {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"type: 'Simple',");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"title: `SessionSpeechlet - ${title}`,");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"content: `SessionSpeechlet - ${output}`,");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"},");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"reprompt: {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"outputSpeech: {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"type: 'PlainText',");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"text: repromptText,");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"},");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"},");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"shouldEndSession,");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"function buildResponse(sessionAttributes, speechletResponse) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"console.log(\"Responding with \" + JSON.stringify(speechletResponse));");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"return {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"version: '1.0',");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"sessionAttributes,");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"response: speechletResponse,");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"function buildSpeechletResponseDelegate(shouldEndSession) {");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"return {");
        _builder.newLine();
        _builder.append((Object)"          ");
        _builder.append((Object)"outputSpeech:null,");
        _builder.newLine();
        _builder.append((Object)"          ");
        _builder.append((Object)"directives: [");
        _builder.newLine();
        _builder.append((Object)"                  ");
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"                      ");
        _builder.append((Object)"\"type\": \"Dialog.Delegate\",");
        _builder.newLine();
        _builder.append((Object)"                      ");
        _builder.append((Object)"\"updatedIntent\": null");
        _builder.newLine();
        _builder.append((Object)"                  ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"              ");
        _builder.append((Object)"],");
        _builder.newLine();
        _builder.append((Object)"         ");
        _builder.append((Object)"reprompt: null,");
        _builder.newLine();
        _builder.append((Object)"          ");
        _builder.append((Object)"shouldEndSession: shouldEndSession");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// --------------- Functions that control the skill's behavior -----------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"function getWelcomeResponse(callback) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"console.log(\"in welcomeResponse\");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// If we wanted to initialize the session to have some attributes we could add those here.");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const sessionAttributes = {};");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const cardTitle = 'Welcome';");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const speechOutput = 'what do you want to do?';");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const repromptText = \"\";");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const shouldEndSession = false;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"callback(sessionAttributes,");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"buildSpeechletResponse(cardTitle, speechOutput, repromptText, shouldEndSession));");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList _properties = element.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            boolean _notEquals;
            FunctionblockModel _type = fbProperty.getType();
            FunctionBlock _functionblock = _type.getFunctionblock();
            Status _status = _functionblock.getStatus();
            boolean bl = _notEquals = !Objects.equal((Object)_status, null);
            if (!_notEquals) continue;
            FunctionblockModel _type_1 = fbProperty.getType();
            FunctionBlock _functionblock_1 = _type_1.getFunctionblock();
            Status _status_1 = _functionblock_1.getStatus();
            EList _properties_1 = _status_1.getProperties();
            for (Property statusProperty : _properties_1) {
                Map _configurationProperties_4;
                String _orDefault_4;
                boolean _equalsIgnoreCase_3;
                _builder.append((Object)"function fetch");
                String _name_1 = fbProperty.getName();
                String _firstUpper = StringExtensions.toFirstUpper((String)_name_1);
                _builder.append((Object)_firstUpper, "");
                String _name_2 = statusProperty.getName();
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
                _builder.append((Object)_firstUpper_1, "");
                _builder.append((Object)"(request, session, callback){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t ");
                _builder.append((Object)"console.log(\"in fetch");
                String _name_3 = fbProperty.getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                _builder.append((Object)_firstUpper_2, "\t ");
                String _name_4 = statusProperty.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_4);
                _builder.append((Object)_firstUpper_3, "\t ");
                _builder.append((Object)"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t ");
                _builder.newLine();
                _builder.append((Object)"\t  ");
                _builder.append((Object)"var sessionAttributes = {};");
                _builder.newLine();
                Map _configurationProperties_3 = context.getConfigurationProperties();
                String _orDefault_3 = _configurationProperties_3.getOrDefault("boschcloud", "false");
                boolean _equalsIgnoreCase_2 = _orDefault_3.equalsIgnoreCase("true");
                if (_equalsIgnoreCase_2) {
                    _builder.append((Object)"\t ");
                    _builder.append((Object)" ");
                    _builder.append((Object)"var httpRequest = {");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"host : \"things.apps.bosch-iot-cloud.com\",");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"path: \"/api/1/things/\"+thingId,");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"method: 'GET',");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"headers: {");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"'Content-Type': 'application/json',");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"'x-cr-api-token': thingsApiToken,");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"'Authorization' : \"Basic \" + new Buffer(username + \":\" + password).toString(\"base64\")");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)" ");
                    _builder.append((Object)"};");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"console.log(\"url: \"+JSON.stringify(httpRequest));");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"http.get(httpRequest, function(response) {");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"response.on('data', function(data) {");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"var result = JSON.parse(data);");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"speechOutput = result.features.");
                    String _name_5 = fbProperty.getName();
                    _builder.append((Object)_name_5, "\t \t\t");
                    _builder.append((Object)".properties.status.");
                    String _name_6 = statusProperty.getName();
                    _builder.append((Object)_name_6, "\t \t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"//say the results");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"callback(sessionAttributes, buildSpeechletResponse(\"");
                    String _name_7 = fbProperty.getName();
                    _builder.append((Object)_name_7, "\t \t\t");
                    _builder.append((Object)"\", speechOutput, \"\", true));");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"});");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"});");
                    _builder.newLine();
                }
                if (_equalsIgnoreCase_3 = (_orDefault_4 = (_configurationProperties_4 = context.getConfigurationProperties()).getOrDefault("awsiot", "false")).equalsIgnoreCase("true")) {
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"iotdata.getThingShadow({");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"thingName: config.thingName");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"},function(err, data) {");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if (err) {");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"callback(err);");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"} else {          ");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"var jsonPayload = JSON.parse(data.payload);");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"speechOutput = jsonPayload.state.reported[\"");
                    String _name_8 = element.getName();
                    _builder.append((Object)_name_8, "\t \t\t");
                    _builder.append((Object)"\"];");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"callback(sessionAttributes, buildSpeechletResponse(\"");
                    String _name_9 = fbProperty.getName();
                    _builder.append((Object)_name_9, "\t \t\t");
                    _builder.append((Object)"\", speechOutput, \"\", true));");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"});");
                    _builder.newLine();
                }
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append((Object)"function handleSessionEndRequest(callback) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const cardTitle = 'Session Ended';");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const speechOutput = 'Have a nice day!';");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Setting this to true ends the session and exits the skill.");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const shouldEndSession = true;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"callback({}, buildSpeechletResponse(cardTitle, speechOutput, null, shouldEndSession));");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// --------------- Events -----------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Called when the session starts.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"function onSessionStarted(sessionStartedRequest, session) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"console.log(`onSessionStarted requestId=${sessionStartedRequest.requestId}, sessionId=${session.sessionId}`);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Called when the user launches the skill without specifying what they want.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"function onLaunch(request, session, callback) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"//console.log(`onLaunch requestId=${launchRequest.requestId}, sessionId=${session.sessionId}`);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"console.log(\"in launchRequest\");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"console.log(\"  request: \"+JSON.stringify(request));");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Dispatch to your skill's launch.");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"getWelcomeResponse(callback);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Called when the user specifies an intent for this skill.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"function onIntent(request, session, callback) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"//console.log(`onIntent requestId=${intentRequest.requestId}, sessionId=${session.sessionId}`);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"console.log(\"in onIntent\");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"console.log(\"  request: \"+JSON.stringify(request));");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const intent = request.intent;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"const intentName = request.intent.name;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Dispatch to your skill's intent handlers");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if (intentName === 'AMAZON.HelpIntent') {");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"getWelcomeResponse(callback);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"} else if (intentName === 'AMAZON.StopIntent' || intentName === 'AMAZON.CancelIntent') {");
        _builder.newLine();
        _builder.append((Object)"    \t");
        _builder.append((Object)"handleSessionEndRequest(callback);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"} ");
        _builder.newLine();
        EList _properties_2 = element.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_2) {
            boolean _notEquals_1;
            FunctionblockModel _type_2 = fbProperty_1.getType();
            FunctionBlock _functionblock_2 = _type_2.getFunctionblock();
            Status _status_2 = _functionblock_2.getStatus();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_status_2, null);
            if (!_notEquals_1) continue;
            FunctionblockModel _type_3 = fbProperty_1.getType();
            FunctionBlock _functionblock_3 = _type_3.getFunctionblock();
            Status _status_3 = _functionblock_3.getStatus();
            EList _properties_3 = _status_3.getProperties();
            for (Property statusProperty_1 : _properties_3) {
                _builder.append((Object)"    ");
                _builder.append((Object)"else if (intentName === '");
                String _name_10 = fbProperty_1.getName();
                String _replace = _name_10.replace("_", "");
                _builder.append((Object)_replace, "    ");
                String _name_11 = statusProperty_1.getName();
                String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_11);
                String _replace_1 = _firstUpper_4.replace("_", "");
                _builder.append((Object)_replace_1, "    ");
                _builder.append((Object)"') {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"\t");
                _builder.append((Object)"fetch");
                String _name_12 = fbProperty_1.getName();
                String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_12);
                _builder.append((Object)_firstUpper_5, "    \t");
                String _name_13 = statusProperty_1.getName();
                String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_13);
                _builder.append((Object)_firstUpper_6, "    \t");
                _builder.append((Object)"(request, session, callback);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.append((Object)"   \t ");
        _builder.append((Object)"else {");
        _builder.newLine();
        _builder.append((Object)"   \t \t");
        _builder.append((Object)"throw new Error('Invalid intent');");
        _builder.newLine();
        _builder.append((Object)"   \t ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Called when the user ends the session.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Is not called when the skill returns shouldEndSession=true.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"function onSessionEnded(sessionEndedRequest, session) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"console.log(`onSessionEnded requestId=${sessionEndedRequest.requestId}, sessionId=${session.sessionId}`);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"// Add cleanup logic here");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// --------------- Main handler -----------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// Route the incoming request based on type (LaunchRequest, IntentRequest,");
        _builder.newLine();
        _builder.append((Object)"// etc.) The JSON body of the request is provided in the event parameter.");
        _builder.newLine();
        _builder.append((Object)"exports.handler = (event, context, callback) => {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"// console.log(`event.session.application.applicationId=${event.session.application.applicationId}`);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"console.log(\"EVENT=====\" + JSON.stringify(event));");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"         ");
        _builder.append((Object)"* Uncomment this if statement and populate with your skill's application ID to");
        _builder.newLine();
        _builder.append((Object)"         ");
        _builder.append((Object)"* prevent someone else from configuring a skill that sends requests to this function.");
        _builder.newLine();
        _builder.append((Object)"         ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if (event.session.application.applicationId !== 'amzn1.echo-sdk-ams.app.[unique-value-here]') {");
        _builder.newLine();
        _builder.append((Object)"             ");
        _builder.append((Object)"callback('Invalid Application ID');");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if (event.session.new) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"onSessionStarted({ requestId: event.request.requestId }, event.session);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if (event.request.type === 'LaunchRequest') {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"onLaunch(event.request,");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"event.session,");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"(sessionAttributes, speechletResponse) => {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"callback(null, buildResponse(sessionAttributes, speechletResponse));");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} else if (event.request.type === 'IntentRequest') {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"onIntent(event.request,");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"event.session,");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"(sessionAttributes, speechletResponse) => {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"callback(null, buildResponse(sessionAttributes, speechletResponse));");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} else if (event.request.type === 'SessionEndedRequest') {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"onSessionEnded(event.request, event.session);");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"callback();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"} catch (err) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"callback(err);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }
}

