/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleLinkedList<E>
implements List<E> {
    private Entry<E> entry;
    private int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (E e : this) {
                if (null != e) continue;
                return true;
            }
        } else {
            for (E e : this) {
                if (!o.equals(e)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this.values();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        return this.toArray(array);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        T[] array = a;
        int i = 0;
        for (E e : this) {
            array[i++] = e;
        }
        return array;
    }

    @Override
    public boolean add(E e) {
        this.entry = new Entry(e, this.entry);
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("containsAll");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public void clear() {
        this.entry = null;
        this.size = 0;
    }

    @Override
    public E get(int index) {
        this.bounds(index);
        int i = this.size;
        for (E e : this) {
            if (--i != index) continue;
            return e;
        }
        throw new IllegalStateException("statement should not be reachable");
    }

    @Override
    public E set(int index, E element) {
        this.bounds(index);
        int i = this.size;
        for (Entry entry : this.entries()) {
            if (--i != index) continue;
            Object old = entry.value;
            entry.value = element;
            return (E)old;
        }
        throw new IllegalStateException("statement should not be reachable");
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("indexOf");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("lastIndexOf");
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException("listIterator");
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException("listIterator");
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList");
    }

    private void bounds(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(index + " [size " + this.size + "]");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " [size " + this.size + "]");
        }
    }

    private Iterator<E> values() {
        return new Values(this.entry);
    }

    private Entries entries() {
        return new Entries(this.entry);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entries
    implements Iterator<Entry<E>>,
    Iterable<Entry<E>> {
        private Entry<E> current;

        private Entries(Entry<E> current) {
            this.current = current;
        }

        @Override
        public Iterator<Entry<E>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Entry<E> next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Entry value = this.current;
            this.current = this.current.next;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry<E> {
        private E value;
        private Entry next;

        private Entry(E value, Entry next) {
            this.value = value;
            this.next = next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values<E>
    implements Iterator<E> {
        private Entry<E> current;

        private Values(Entry<E> current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public E next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object v = ((Entry)this.current).value;
            this.current = ((Entry)this.current).next;
            return (E)v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

