/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.testing;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.cdi.ScopeHelper;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.naming.InitContextFactory;
import org.apache.openejb.injection.FallbackPropertyInjector;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.testing.AppResource;
import org.apache.openejb.testing.Classes;
import org.apache.openejb.testing.Component;
import org.apache.openejb.testing.Configuration;
import org.apache.openejb.testing.Descriptor;
import org.apache.openejb.testing.Descriptors;
import org.apache.openejb.testing.EnableServices;
import org.apache.openejb.testing.MockInjector;
import org.apache.openejb.testing.Module;
import org.apache.openejb.testing.TestInstance;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.ServiceManagerProxy;
import org.apache.openejb.util.URLs;
import org.apache.openejb.web.LightweightWebAppBuilder;
import org.apache.webbeans.inject.AbstractInjectable;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.web.lifecycle.test.MockHttpSession;
import org.apache.webbeans.web.lifecycle.test.MockServletContext;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;

public final class ApplicationComposers {
    public static final String OPENEJB_APPLICATION_COMPOSER_CONTEXT = "openejb.application.composer.context";
    private static final Class[] MODULE_TYPES = new Class[]{IAnnotationFinder.class, ClassesArchive.class, AppModule.class, WebModule.class, EjbModule.class, Application.class, WebApp.class, EjbJar.class, EnterpriseBean.class, Persistence.class, PersistenceUnit.class, Connector.class, Beans.class, Class[].class};
    private final ClassFinder testClassFinder;
    private final Class<?> testClass;
    private ServiceManagerProxy serviceManager = null;
    private AppInfo appInfo = null;
    private Assembler assembler = null;
    private AppContext appContext = null;
    private ThreadContext previous = null;
    private MockHttpSession session = null;
    private MockServletContext servletContext = null;

    public ApplicationComposers(Class<?> klass) {
        this.testClass = klass;
        this.testClassFinder = new ClassFinder(new Class[]{klass});
        this.validate();
    }

    private void validate() {
        String gripe;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        ArrayList configs = new ArrayList();
        configs.addAll(this.testClassFinder.findAnnotatedMethods(Configuration.class));
        configs.addAll(this.testClassFinder.findAnnotatedMethods(org.apache.openejb.junit.Configuration.class));
        if (configs.size() > 1) {
            String gripe2 = "Test class should have no more than one @Configuration method";
            errors.add(new Exception("Test class should have no more than one @Configuration method"));
        }
        if (this.testClassFinder.findAnnotatedMethods(org.apache.openejb.junit.MockInjector.class).size() + this.testClassFinder.findAnnotatedMethods(MockInjector.class).size() > 1) {
            errors.add(new Exception("Test class should have no more than one @MockInjector method"));
        }
        for (Method method : configs) {
            Class<?> type = method.getReturnType();
            if (Properties.class.isAssignableFrom(type)) continue;
            String gripe3 = "@Configuration method must return " + Properties.class.getName();
            errors.add(new Exception(gripe3));
        }
        ArrayList components = new ArrayList();
        components.addAll(this.testClassFinder.findAnnotatedMethods(Component.class));
        components.addAll(this.testClassFinder.findAnnotatedMethods(org.apache.openejb.junit.Component.class));
        for (Method method : components) {
            if (method.getParameterTypes().length <= 0) continue;
            errors.add(new Exception("@Component methods shouldn't take any parameters"));
        }
        ArrayList descriptors = new ArrayList();
        descriptors.addAll(this.testClassFinder.findAnnotatedMethods(Descriptors.class));
        descriptors.addAll(this.testClassFinder.findAnnotatedMethods(org.apache.openejb.junit.Descriptors.class));
        for (Method method : descriptors) {
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(WebModule.class) || returnType.equals(EjbModule.class) || returnType.equals(WebApp.class) || returnType.equals(EjbJar.class) || returnType.equals(AppModule.class)) continue;
            errors.add(new Exception("@Descriptors can't be used on " + returnType.getName()));
        }
        ArrayList classes = new ArrayList();
        classes.addAll(this.testClassFinder.findAnnotatedMethods(Classes.class));
        classes.addAll(this.testClassFinder.findAnnotatedMethods(org.apache.openejb.junit.Classes.class));
        for (Method method : classes) {
            Class<?> returnType = method.getReturnType();
            if (returnType.equals(WebModule.class) || returnType.equals(EjbModule.class) || returnType.equals(WebApp.class) || returnType.equals(EjbJar.class)) continue;
            errors.add(new Exception("@Classes can't be used on a method returning " + returnType));
        }
        int appModules = 0;
        int modules = 0;
        ArrayList moduleMethods = new ArrayList();
        moduleMethods.addAll(this.testClassFinder.findAnnotatedMethods(Module.class));
        moduleMethods.addAll(this.testClassFinder.findAnnotatedMethods(org.apache.openejb.junit.Module.class));
        for (Method method : moduleMethods) {
            ++modules;
            Class<?> type = method.getReturnType();
            if (Application.class.isAssignableFrom(type)) {
                ++appModules;
                continue;
            }
            if (this.isValidModuleType(type, MODULE_TYPES)) continue;
            String gripe4 = "@Module method must return " + Join.join(" or ", MODULE_TYPES).replaceAll("(class|interface) ", "");
            errors.add(new Exception(gripe4));
        }
        if (appModules > 1) {
            gripe = "Test class should have no more than one @Module method that returns " + Application.class.getName();
            errors.add(new Exception(gripe));
        }
        if (modules < 1) {
            gripe = "Test class should have at least one @Module method";
            errors.add(new Exception("Test class should have at least one @Module method"));
        }
        if (!errors.isEmpty()) {
            throw new OpenEJBRuntimeException(((Object)errors).toString());
        }
    }

    private boolean isValidModuleType(Class<?> type, Class<?>[] moduleTypes) {
        for (Class<?> moduleType : moduleTypes) {
            if (!moduleType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(Object testInstance) throws Exception {
        org.apache.openejb.junit.EnableServices annotationOld;
        ClassLoader loader = this.testClass.getClassLoader();
        AppModule appModule = new AppModule(loader, this.testClass.getSimpleName());
        EjbJar ejbJar = new EjbJar();
        OpenejbJar openejbJar = new OpenejbJar();
        ManagedBean bean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(this.testClass.getSimpleName(), this.testClass.getName(), true));
        bean.setTransactionType(TransactionType.BEAN);
        EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)bean);
        ejbDeployment.setDeploymentId(this.testClass.getName());
        appModule.getEjbModules().add(new EjbModule(ejbJar, openejbJar));
        Properties configuration = new Properties();
        configuration.put("openejb.deployments.classpath", "false");
        EnableServices annotation = this.testClass.getAnnotation(EnableServices.class);
        if (annotation != null && annotation.httpDebug()) {
            configuration.setProperty("httpejbd.print", "true");
            configuration.setProperty("httpejbd.indent.xml", "true");
            configuration.setProperty("logging.level.OpenEJB.server.http", "FINE");
        }
        if ((annotationOld = this.testClass.getAnnotation(org.apache.openejb.junit.EnableServices.class)) != null && annotationOld.httpDebug()) {
            configuration.setProperty("httpejbd.print", "true");
            configuration.setProperty("httpejbd.indent.xml", "true");
            configuration.setProperty("logging.level.OpenEJB.server.http", "FINE");
        }
        ArrayList configs = new ArrayList();
        configs.addAll(this.testClassFinder.findAnnotatedMethods(Configuration.class));
        configs.addAll(this.testClassFinder.findAnnotatedMethods(org.apache.openejb.junit.Configuration.class));
        for (Method method : configs) {
            Object o = method.invoke(testInstance, new Object[0]);
            if (!(o instanceof Properties)) continue;
            Properties properties = (Properties)o;
            configuration.putAll((Map<?, ?>)properties);
        }
        if (SystemInstance.isInitialized()) {
            SystemInstance.reset();
        }
        SystemInstance.init((Properties)configuration);
        SystemInstance.get().setComponent(TestInstance.class, (Object)new TestInstance(this.testClass, testInstance));
        ArrayList mockInjectors = new ArrayList(this.testClassFinder.findAnnotatedMethods(MockInjector.class));
        mockInjectors.addAll(this.testClassFinder.findAnnotatedMethods(org.apache.openejb.junit.MockInjector.class));
        if (!mockInjectors.isEmpty()) {
            Object o = ((Method)mockInjectors.iterator().next()).invoke(testInstance, new Object[0]);
            if (o instanceof Class) {
                o = ((Class)o).newInstance();
            }
            if (o instanceof FallbackPropertyInjector) {
                SystemInstance.get().setComponent(FallbackPropertyInjector.class, (Object)((FallbackPropertyInjector)o));
            }
        }
        for (Method method : this.testClassFinder.findAnnotatedMethods(Component.class)) {
            this.setComponent(testInstance, method);
        }
        for (Method method : this.testClassFinder.findAnnotatedMethods(org.apache.openejb.junit.Component.class)) {
            this.setComponent(testInstance, method);
        }
        Map<String, URL> additionalDescriptors = ApplicationComposers.descriptorsToMap(this.testClass.getAnnotation(org.apache.openejb.junit.Descriptors.class));
        Map<String, URL> additionalDescriptorsNew = ApplicationComposers.descriptorsToMap(this.testClass.getAnnotation(Descriptors.class));
        additionalDescriptors.putAll(additionalDescriptorsNew);
        Application application = null;
        int webModulesNb = 0;
        ArrayList moduleMethods = new ArrayList();
        moduleMethods.addAll(this.testClassFinder.findAnnotatedMethods(Module.class));
        moduleMethods.addAll(this.testClassFinder.findAnnotatedMethods(org.apache.openejb.junit.Module.class));
        for (Method method : moduleMethods) {
            Class[] beans;
            Object bean2;
            EjbModule ejbModule;
            EjbModule ejbModule2;
            Object obj = method.invoke(testInstance, new Object[0]);
            Classes classesAnnotation = method.getAnnotation(Classes.class);
            org.apache.openejb.junit.Classes classesAnnotationOld = method.getAnnotation(org.apache.openejb.junit.Classes.class);
            Class<?>[] classes = null;
            boolean cdi = false;
            if (classesAnnotation != null) {
                classes = classesAnnotation.value();
                cdi = classesAnnotation.cdi();
            } else if (classesAnnotationOld != null) {
                classes = classesAnnotationOld.value();
            }
            if (obj instanceof WebApp) {
                ++webModulesNb;
                WebApp webapp = (WebApp)obj;
                String root = webapp.getContextRoot();
                if (root == null) {
                    root = "/openejb";
                }
                WebModule webModule = new WebModule(webapp, root, Thread.currentThread().getContextClassLoader(), "", root);
                webModule.getAltDDs().putAll(additionalDescriptors);
                webModule.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(method.getAnnotation(Descriptors.class)));
                if (classes != null) {
                    webModule.setFinder(ApplicationComposers.finderFromClasses(classes));
                }
                EjbModule ejbModule3 = DeploymentLoader.addWebModule(webModule, appModule);
                if (!cdi) continue;
                ejbModule3.setBeans(new Beans());
                continue;
            }
            if (obj instanceof WebModule) {
                ++webModulesNb;
                WebModule webModule = (WebModule)obj;
                webModule.getAltDDs().putAll(additionalDescriptors);
                webModule.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(method.getAnnotation(Descriptors.class)));
                if (classes != null) {
                    webModule.setFinder(ApplicationComposers.finderFromClasses(classes));
                }
                DeploymentLoader.addWebModule(webModule, appModule);
                continue;
            }
            if (obj instanceof EjbModule) {
                ejbModule2 = (EjbModule)obj;
                ejbModule2.getAltDDs().putAll(additionalDescriptors);
                ejbModule2.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(method.getAnnotation(Descriptors.class)));
                if (classes != null) {
                    ejbModule2.setFinder(ApplicationComposers.finderFromClasses(classes));
                }
                ejbModule2.initAppModule(appModule);
                appModule.getEjbModules().add(ejbModule2);
                continue;
            }
            if (obj instanceof EjbJar) {
                EjbJar ejbJar2 = (EjbJar)obj;
                this.setId(ejbJar2, method);
                ejbModule = new EjbModule(ejbJar2);
                ejbModule.getAltDDs().putAll(additionalDescriptors);
                ejbModule.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(method.getAnnotation(Descriptors.class)));
                appModule.getEjbModules().add(ejbModule);
                if (classes == null) continue;
                ejbModule.setFinder(ApplicationComposers.finderFromClasses(classes));
                continue;
            }
            if (obj instanceof EnterpriseBean) {
                bean2 = (EnterpriseBean)obj;
                EjbJar ejbJar3 = new EjbJar(method.getName());
                ejbJar3.addEnterpriseBean(bean2);
                EjbModule ejbModule4 = new EjbModule(ejbJar3);
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(bean2.getEjbClass());
                ejbModule4.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(new Class[]{clazz})).link());
                appModule.getEjbModules().add(ejbModule4);
                continue;
            }
            if (obj instanceof Application) {
                application = (Application)obj;
                this.setId(application, method);
                continue;
            }
            if (obj instanceof Connector) {
                Connector connector = (Connector)obj;
                this.setId(connector, method);
                appModule.getConnectorModules().add(new ConnectorModule(connector));
                continue;
            }
            if (obj instanceof Persistence) {
                Persistence persistence = (Persistence)obj;
                appModule.addPersistenceModule(new PersistenceModule(appModule, ApplicationComposers.implicitRootUrl(), persistence));
                continue;
            }
            if (obj instanceof PersistenceUnit) {
                PersistenceUnit unit = (PersistenceUnit)obj;
                appModule.addPersistenceModule(new PersistenceModule(appModule, ApplicationComposers.implicitRootUrl(), new Persistence(new PersistenceUnit[]{unit})));
                continue;
            }
            if (obj instanceof Beans) {
                beans = (Class[])obj;
                ejbModule = new EjbModule(new EjbJar(method.getName()));
                ejbModule.setBeans((Beans)beans);
                if (classes != null) {
                    ejbModule.setFinder(ApplicationComposers.finderFromClasses(classes));
                }
                appModule.getEjbModules().add(ejbModule);
                continue;
            }
            if (obj instanceof Class[]) {
                beans = (Class[])obj;
                ejbModule = new EjbModule(new EjbJar(method.getName()));
                ejbModule.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(beans)).link());
                ejbModule.setBeans(new Beans());
                appModule.getEjbModules().add(ejbModule);
                continue;
            }
            if (obj instanceof Class) {
                bean2 = (Class)obj;
                ejbModule = new EjbModule(new EjbJar(method.getName()));
                ejbModule.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(new Class[]{bean2})).link());
                ejbModule.setBeans(new Beans());
                appModule.getEjbModules().add(ejbModule);
                continue;
            }
            if (obj instanceof IAnnotationFinder) {
                ejbModule2 = new EjbModule(new EjbJar(method.getName()));
                ejbModule2.setFinder((IAnnotationFinder)obj);
                ejbModule2.setBeans(new Beans());
                appModule.getEjbModules().add(ejbModule2);
                continue;
            }
            if (obj instanceof ClassesArchive) {
                ejbModule2 = new EjbModule(new EjbJar(method.getName()));
                ejbModule2.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)obj).link());
                ejbModule2.setBeans(new Beans());
                appModule.getEjbModules().add(ejbModule2);
                continue;
            }
            if (!(obj instanceof AppModule)) continue;
            AppModule module = (AppModule)obj;
            module.getAltDDs().putAll(additionalDescriptors);
            module.getAltDDs().putAll(ApplicationComposers.descriptorsToMap(method.getAnnotation(Descriptors.class)));
            if (module.getWebModules().size() > 0) {
                ++webModulesNb;
            }
            appModule.getEjbModules().addAll(module.getEjbModules());
            appModule.getPersistenceModules().addAll(module.getPersistenceModules());
            appModule.getAdditionalLibMbeans().addAll(module.getAdditionalLibMbeans());
            appModule.getWebModules().addAll(module.getWebModules());
            appModule.getConnectorModules().addAll(module.getConnectorModules());
            appModule.getResources().addAll(module.getResources());
            appModule.getServices().addAll(module.getServices());
            appModule.getPojoConfigurations().putAll(module.getPojoConfigurations());
            appModule.getAdditionalLibraries().addAll(module.getAdditionalLibraries());
            appModule.getAltDDs().putAll(module.getAltDDs());
            appModule.getProperties().putAll((Map<?, ?>)module.getProperties());
        }
        if (application != null) {
            AppModule newModule = new AppModule(appModule.getClassLoader(), appModule.getModuleId(), application, false);
            newModule.getClientModules().addAll(appModule.getClientModules());
            newModule.addPersistenceModules(appModule.getPersistenceModules());
            newModule.getEjbModules().addAll(appModule.getEjbModules());
            newModule.getConnectorModules().addAll(appModule.getConnectorModules());
            appModule = newModule;
        }
        if (webModulesNb > 0 && SystemInstance.get().getComponent(WebAppBuilder.class) == null) {
            SystemInstance.get().setComponent(WebAppBuilder.class, (Object)new LightweightWebAppBuilder());
        }
        if (moduleMethods.size() == 1 && webModulesNb == 1) {
            appModule.setStandloneWebModule();
        }
        ConfigurationFactory config = new ConfigurationFactory();
        config.init(SystemInstance.get().getProperties());
        this.assembler = new Assembler();
        SystemInstance.get().setComponent(Assembler.class, (Object)this.assembler);
        this.assembler.buildContainerSystem(config.getOpenEjbConfiguration());
        if ("true".equals(configuration.getProperty("openejb.embedded.remotable", "false")) || annotation != null || annotationOld != null) {
            try {
                if (annotation != null) {
                    this.initFilteredServiceManager(annotation.value());
                }
                if (annotationOld != null) {
                    this.initFilteredServiceManager(annotationOld.value());
                }
                this.serviceManager = new ServiceManagerProxy(false);
                this.serviceManager.start();
            }
            catch (ServiceManagerProxy.AlreadyStartedException e) {
                throw new OpenEJBRuntimeException(e);
            }
        }
        this.servletContext = new MockServletContext();
        this.session = new MockHttpSession();
        this.appInfo = config.configureApplication(appModule);
        this.appContext = this.assembler.createApplication(this.appInfo);
        ScopeHelper.startContexts(this.appContext.getWebBeansContext().getContextsService(), (ServletContext)this.servletContext, (HttpSession)this.session);
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        BeanContext context = containerSystem.getBeanContext(this.testClass.getName());
        ThreadContext callContext = new ThreadContext(context, null, Operation.INJECTION);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        try {
            InjectionProcessor<Object> processor = new InjectionProcessor<Object>(testInstance, context.getInjections(), context.getJndiContext());
            processor.createInstance();
            AbstractInjectable.instanceUnderInjection.set(testInstance);
            try {
                OWBInjector.inject((BeanManager)this.appContext.getBeanManager(), (Object)testInstance, null);
                AbstractInjectable.instanceUnderInjection.remove();
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    AbstractInjectable.instanceUnderInjection.remove();
                }
            }
        }
        finally {
            ThreadContext.exit(oldContext);
        }
        System.setProperty("java.naming.factory.initial", InitContextFactory.class.getName());
        System.getProperties().put(OPENEJB_APPLICATION_COMPOSER_CONTEXT, this.appContext.getGlobalJndiContext());
        ArrayList fields = new ArrayList(this.testClassFinder.findAnnotatedFields(AppResource.class));
        fields.addAll(this.testClassFinder.findAnnotatedFields(org.apache.openejb.junit.AppResource.class));
        for (Field field : fields) {
            Class<?> type = field.getType();
            if (AppModule.class.isAssignableFrom(type)) {
                field.setAccessible(true);
                field.set(testInstance, appModule);
                continue;
            }
            if (Context.class.isAssignableFrom(type)) {
                field.setAccessible(true);
                field.set(testInstance, this.appContext.getGlobalJndiContext());
                continue;
            }
            throw new IllegalArgumentException("can't find value for type " + type.getName());
        }
        this.previous = ThreadContext.enter(new ThreadContext(context, null, Operation.BUSINESS));
    }

    private void setComponent(Object testInstance, Method method) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> key;
        Object value = method.invoke(testInstance, new Object[0]);
        if (value instanceof Class) {
            value = ((Class)value).newInstance();
        }
        if (!(key = method.getReturnType()).isInstance(value)) {
            throw new OpenEJBRuntimeException(value + " is not an instance of " + key.getName());
        }
        SystemInstance.get().setComponent(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(Object testInstance, Callable<Void> next) throws Exception {
        this.before(testInstance);
        try {
            next.call();
        }
        finally {
            if (this.previous != null) {
                ThreadContext.exit(this.previous);
            }
            this.after();
        }
    }

    public void after() throws Exception {
        if (this.servletContext != null || this.session != null) {
            try {
                ScopeHelper.stopContexts(this.appContext.getWebBeansContext().getContextsService(), (ServletContext)this.servletContext, (HttpSession)this.session);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.assembler != null) {
            try {
                this.assembler.destroyApplication(this.appInfo.path);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.serviceManager != null) {
            try {
                this.serviceManager.stop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        OpenEJB.destroy();
    }

    private <Module extends NamedModule> Module setId(Module module, Method method) {
        return this.setId(module, method.getName());
    }

    private <Module extends NamedModule> Module setId(Module module, String name) {
        if (module.getModuleName() != null) {
            return module;
        }
        if (module.getId() != null) {
            return module;
        }
        module.setId(name);
        return module;
    }

    private static String implicitRootUrl() {
        ResourceFinder finder = new ResourceFinder("", Thread.currentThread().getContextClassLoader());
        try {
            URL url = DeploymentLoader.altDDSources(DeploymentLoader.mapDescriptors(finder), false).get("persistence.xml");
            if (url == null) {
                return "";
            }
            File file = URLs.toFile(url);
            if (file.getName().endsWith("persistence.xml")) {
                String parent = file.getParentFile().getName();
                if (parent.equalsIgnoreCase("META-INF")) {
                    return file.getParentFile().getParentFile().getAbsolutePath();
                }
                return file.getParentFile().getAbsolutePath();
            }
            return url.toExternalForm();
        }
        catch (IOException e) {
            return "";
        }
    }

    private static Map<String, URL> descriptorsToMap(Object descriptors) {
        if (descriptors != null) {
            HashMap<String, URL> dds = new HashMap<String, URL>();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (descriptors instanceof Descriptors) {
                for (Descriptor descriptor : ((Descriptors)descriptors).value()) {
                    dds.put(descriptor.name(), loader.getResource(descriptor.path()));
                }
            } else if (descriptors instanceof org.apache.openejb.junit.Descriptors) {
                for (org.apache.openejb.junit.Descriptor descriptor : ((org.apache.openejb.junit.Descriptors)descriptors).value()) {
                    dds.put(descriptor.name(), loader.getResource(descriptor.path()));
                }
            }
            return dds;
        }
        return Collections.emptyMap();
    }

    private static IAnnotationFinder finderFromClasses(Class<?>[] value) {
        return new AnnotationFinder((Archive)new ClassesArchive((Class[])value)).link();
    }

    private void initFilteredServiceManager(String[] services) {
        Class<?> serviceManagerClass;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            serviceManagerClass = classLoader.loadClass("org.apache.openejb.server.FilteredServiceManager");
        }
        catch (ClassNotFoundException e) {
            String msg = "Services filtering requires class 'org.apache.openejb.server.FilteredServiceManager' to be available.  Make sure you have the openejb-server-*.jar in your classpath.";
            throw new IllegalStateException(msg, e);
        }
        Method initServiceManager = null;
        try {
            initServiceManager = serviceManagerClass.getMethod("initServiceManager", String[].class);
            initServiceManager.invoke(null, new Object[]{services});
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed initializing FilteredServiceManager with services " + services, e);
        }
    }

    private static void linkageErrorProtection() {
        ClassLoader loader = ApplicationComposers.class.getClassLoader();
        try {
            Class.forName("sun.security.pkcs11.SunPKCS11", true, loader);
            Class.forName("sun.security.pkcs11.SunPKCS11$Descriptor", true, loader);
            Class.forName("sun.security.pkcs11.wrapper.PKCS11Exception", true, loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        ApplicationComposers.linkageErrorProtection();
    }
}

