/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.impl.tpt.threadpool;

import java.security.AccessControlContext;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.ThreadPoolFactoryImpl;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.ThreadPoolManagerImpl;
import org.eclipse.equinox.internal.util.pool.ObjectCreator;

class Job
implements ObjectCreator {
    public Runnable run;
    public String name;
    public String context;
    public int priority = -1;
    public ThreadPoolFactoryImpl factory;
    AccessControlContext acc;
    public Job root = null;
    public Job last = null;
    private Job next;
    int counter = 0;

    Job() {
    }

    private void setJob(Runnable run, String name, int priority, ThreadPoolFactoryImpl factory, AccessControlContext acc) {
        this.run = run;
        this.name = name;
        this.priority = priority;
        this.factory = factory;
        this.acc = acc;
    }

    public Object getInstance() {
        return new Job();
    }

    public Job addJob(Runnable run, String name, int priority, ThreadPoolFactoryImpl factory, AccessControlContext acc) {
        Job tmp = (Job)ThreadPoolManagerImpl.jobPool.getObject();
        ++this.counter;
        tmp.setJob(run, name, priority, factory, acc);
        if (this.root == null) {
            this.root = tmp;
            this.last = tmp;
            return tmp;
        }
        this.last.next = tmp;
        this.last = tmp;
        return tmp;
    }

    public void addJob(Job j) {
        ++this.counter;
        if (this.root == null) {
            this.root = j;
            this.last = j;
            return;
        }
        this.last.next = j;
        this.last = j;
    }

    private void clear() {
        this.next = null;
    }

    public void fullClear() {
        this.next = null;
        this.run = null;
        this.name = null;
        this.context = null;
        this.acc = null;
    }

    public Job getJob() {
        Job r = null;
        if (this.root == null) {
            return null;
        }
        --this.counter;
        r = this.root;
        this.root = this.root.next;
        if (this.root == null) {
            this.last = this.root;
        }
        r.clear();
        return r;
    }
}

