/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.validation.ConstraintDefinitionException;
import org.apache.bval.jsr303.util.SecureActions;

public class ConstraintDefinitionValidator {
    public static void validateConstraintDefinition(Annotation annotation) {
        ConstraintDefinitionValidator.validGroups(annotation);
        ConstraintDefinitionValidator.validPayload(annotation);
        ConstraintDefinitionValidator.validMessage(annotation);
        ConstraintDefinitionValidator.validAttributes(annotation);
    }

    private static void validGroups(Annotation annotation) {
        Method groupsMethod = SecureActions.getMethod(annotation.annotationType(), "groups");
        if (groupsMethod == null) {
            throw new ConstraintDefinitionException("Constraint definition " + annotation + " has no groups() method");
        }
        Object defaultGroupsValue = groupsMethod.getDefaultValue();
        if (defaultGroupsValue instanceof Class[]) {
            if (((Class[])defaultGroupsValue).length != 0) {
                throw new ConstraintDefinitionException("Default value for groups() must be an empty array");
            }
        } else {
            throw new ConstraintDefinitionException("Return type for groups() must be of type Class<?>[]");
        }
    }

    private static void validPayload(Annotation annotation) {
        Method payloadMethod = SecureActions.getMethod(annotation.annotationType(), "payload");
        if (payloadMethod == null) {
            throw new ConstraintDefinitionException("Constraint definition " + annotation + " has no payload() method");
        }
        Object defaultPayloadValue = payloadMethod.getDefaultValue();
        if (defaultPayloadValue instanceof Class[]) {
            if (((Class[])defaultPayloadValue).length != 0) {
                throw new ConstraintDefinitionException("Default value for payload() must be an empty array");
            }
        } else {
            throw new ConstraintDefinitionException("Return type for payload() must be of type Class<? extends Payload>[]");
        }
    }

    private static void validMessage(Annotation annotation) {
        Method messageMethod = SecureActions.getMethod(annotation.annotationType(), "message");
        if (messageMethod == null) {
            throw new ConstraintDefinitionException("Constraint definition " + annotation + " has no message() method");
        }
        Object defaultMessageValue = messageMethod.getDefaultValue();
        if (!(defaultMessageValue instanceof String)) {
            throw new ConstraintDefinitionException("Return type for message() must be of type String");
        }
    }

    private static void validAttributes(Annotation annotation) {
        Method[] methods;
        for (Method method : methods = SecureActions.getDeclaredMethods(annotation.annotationType())) {
            if (!method.getName().toLowerCase(Locale.ENGLISH).startsWith("valid")) continue;
            throw new ConstraintDefinitionException("A constraint annotation cannot have methods which start with 'valid'");
        }
    }
}

