/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.store.access.TransactionController;

public class StatementSchemaPermission
extends StatementPermission {
    private String schemaName;
    private String aid;
    private int privType;

    public StatementSchemaPermission(String string, String string2, int n) {
        this.schemaName = string;
        this.aid = string2;
        this.privType = n;
    }

    public void check(LanguageConnectionContext languageConnectionContext, boolean bl, Activation activation) throws StandardException {
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        String string = languageConnectionContext.getCurrentUserId(activation);
        switch (this.privType) {
            case 17: 
            case 18: {
                SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, false);
                if (schemaDescriptor == null) {
                    return;
                }
                if (string.equals(schemaDescriptor.getAuthorizationId())) break;
                throw StandardException.newException("42507", (Object)string, (Object)this.schemaName);
            }
            case 16: {
                if (this.schemaName.equals(string) && (this.aid == null || this.aid.equals(string))) break;
                throw StandardException.newException("42508", (Object)string, (Object)this.schemaName);
            }
        }
    }

    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        return null;
    }

    private String getPrivName() {
        switch (this.privType) {
            case 16: {
                return "CREATE_SCHEMA";
            }
            case 17: {
                return "MODIFY_SCHEMA";
            }
            case 18: {
                return "DROP_SCHEMA";
            }
        }
        return "?";
    }

    public String toString() {
        return "StatementSchemaPermission: " + this.schemaName + " owner:" + this.aid + " " + this.getPrivName();
    }
}

