/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.openejb.loader.BasicURLClassPath;

public class SystemClassPath
extends BasicURLClassPath {
    private URLClassLoader sysLoader;

    @Override
    public void addJarsToPath(File dir) throws Exception {
        this.addJarsToPath(dir, this.getSystemLoader());
        this.rebuildJavaClassPathVariable();
    }

    @Override
    public void addJarToPath(URL jar) throws Exception {
        this.addJarToPath(jar, this.getSystemLoader());
        this.rebuildJavaClassPathVariable();
    }

    @Override
    public ClassLoader getClassLoader() {
        try {
            return this.getSystemLoader();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URLClassLoader getSystemLoader() throws Exception {
        if (this.sysLoader == null) {
            this.sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        return this.sysLoader;
    }

    private void rebuildJavaClassPathVariable() throws Exception {
        URLClassLoader loader = this.getSystemLoader();
        Object cp = this.getURLClassPath(loader);
        Method getURLsMethod = this.getGetURLsMethod();
        URL[] urls = (URL[])getURLsMethod.invoke(cp, new Object[0]);
        if (urls.length < 1) {
            return;
        }
        StringBuilder path = new StringBuilder(urls.length * 32);
        File s = new File(URLDecoder.decode(urls[0].getFile(), "UTF-8"));
        path.append(s.getPath());
        for (int i = 1; i < urls.length; ++i) {
            path.append(File.pathSeparator);
            s = new File(URLDecoder.decode(urls[i].getFile(), "UTF-8"));
            path.append(s.getPath());
        }
        try {
            System.setProperty("java.class.path", path.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private Method getGetURLsMethod() {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    URLClassLoader loader = SystemClassPath.this.getSystemLoader();
                    Object cp = SystemClassPath.this.getURLClassPath(loader);
                    Class<?> clazz = cp.getClass();
                    try {
                        return clazz.getDeclaredMethod("getURLs", URL.class);
                    }
                    catch (NoSuchMethodException e) {
                        return clazz.getDeclaredMethod("getURLs", new Class[0]);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

