/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.Query;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.ArtifactDescriptorDepository;
import org.eclipse.virgo.repository.internal.StandardAttribute;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;

public final class StandardQuery
implements Query {
    private final Set<Attribute> filters = new HashSet<Attribute>();
    private final ArtifactDescriptorDepository artifactDepository;
    private VersionRange versionRangeFilter;
    private Query.VersionRangeMatchingStrategy versionRangeMatchingStrategy = Query.VersionRangeMatchingStrategy.ALL;
    private final Object filterLock = new Object();
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public StandardQuery(ArtifactDescriptorDepository artifactDepository, String attributeName, String attributeValue) {
        this.artifactDepository = artifactDepository;
        this.addFilter(attributeName, attributeValue);
    }

    public StandardQuery(ArtifactDescriptorDepository artifactDepository, String attributeName, String attributeValue, Map<String, Set<String>> attributeParameters) {
        this.artifactDepository = artifactDepository;
        this.addFilter(attributeName, attributeValue, attributeParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query addFilter(String name, String value) {
        Object object = this.filterLock;
        synchronized (object) {
            this.filters.add(new StandardAttribute(name, value));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query addFilter(String name, String value, Map<String, Set<String>> parameters) {
        Object object = this.filterLock;
        synchronized (object) {
            this.filters.add(new StandardAttribute(name, value, parameters));
        }
        return this;
    }

    @Override
    public Query setVersionRangeFilter(VersionRange versionRange) {
        return this.setVersionRangeFilter(versionRange, Query.VersionRangeMatchingStrategy.HIGHEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query setVersionRangeFilter(VersionRange versionRange, Query.VersionRangeMatchingStrategy strategy) {
        Object object = this.filterLock;
        synchronized (object) {
            this.versionRangeFilter = versionRange;
            this.versionRangeMatchingStrategy = strategy;
        }
        return this;
    }

    @Override
    public Set<RepositoryAwareArtifactDescriptor> run() {
        VersionRange localVersionRange = this.versionRangeFilter;
        Query.VersionRangeMatchingStrategy localVersionRangeMatchingStrategy = this.versionRangeMatchingStrategy;
        Set<RepositoryAwareArtifactDescriptor> resolved = this.artifactDepository.resolveArtifactDescriptors(this.filters);
        if (localVersionRangeMatchingStrategy != null) {
            resolved = localVersionRangeMatchingStrategy.match(resolved, localVersionRange);
        }
        return resolved;
    }

    public String toString() {
        return this.filters.toString();
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.StandardQuery");
    }
}

