/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.openejb.initialiser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.naming.ContextBindings;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.eclipse.virgo.web.enterprise.openejb.initialiser.RedirectingOpenEJBContext;

public class VirgoThreadContextListener
implements ThreadContextListener {
    private static final String REDIRECTING_OPENEJB_CONTEXT = "RedirectingOpenEJBContext";
    protected Method method;

    public VirgoThreadContextListener() {
        ContextBindings.bindContext((Object)REDIRECTING_OPENEJB_CONTEXT, (Context)new RedirectingOpenEJBContext());
        try {
            this.method = ContextBindings.class.getDeclaredMethod("getThreadName", new Class[0]);
            this.method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Expected ContextBinding to have the method getThreadName()");
        }
    }

    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        try {
            OldContextHolder data = new OldContextHolder(this.getThreadName());
            newContext.set(OldContextHolder.class, (Object)data);
        }
        catch (NamingException namingException) {}
        try {
            ContextBindings.bindThread((Object)REDIRECTING_OPENEJB_CONTEXT, null);
        }
        catch (NamingException namingException) {
            ContextBindings.unbindContext((Object)REDIRECTING_OPENEJB_CONTEXT, null);
            throw new IllegalArgumentException("Unable to bind OpenEJB enc");
        }
    }

    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        ContextBindings.unbindThread((Object)REDIRECTING_OPENEJB_CONTEXT, null);
        OldContextHolder data = (OldContextHolder)exitedContext.get(OldContextHolder.class);
        if (data != null && data.oldContextName != null) {
            try {
                ContextBindings.bindThread((Object)data.oldContextName, null);
            }
            catch (NamingException e) {
                System.err.println("Exception in method contextExited");
                e.printStackTrace();
            }
        }
    }

    private Object getThreadName() throws NamingException {
        try {
            Object threadName = this.method.invoke(null, new Object[0]);
            return threadName;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null && e.getCause() instanceof NamingException) {
                throw (NamingException)e.getCause();
            }
            System.err.println("Exception in method getThreadName");
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            System.err.println("Exception in method getThreadName");
            e.printStackTrace();
            return null;
        }
    }

    private static class OldContextHolder {
        private Object oldContextName;

        public OldContextHolder(Object oldContextName) {
            this.oldContextName = oldContextName;
        }
    }
}

