/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept.ejb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptors;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EJBInterceptorConfig {
    private final WebBeansContext webBeansContext;

    public EJBInterceptorConfig(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void configure(AnnotatedType<?> annotatedType, List<InterceptorData> interceptorStack) {
        Asserts.assertNotNull(annotatedType);
        Interceptors incs = (Interceptors)annotatedType.getAnnotation(Interceptors.class);
        if (incs != null) {
            Class[] interceptorClasses;
            for (Class intClass : interceptorClasses = incs.value()) {
                this.configureInterceptorAnnots(intClass, interceptorStack, false, null);
            }
        }
        this.configureBeanAnnots(annotatedType, interceptorStack);
        Class clazz = annotatedType.getJavaClass();
        this.webBeansContext.getInterceptorUtil().filterOverridenLifecycleInterceptor(clazz, interceptorStack);
    }

    private void configureInterceptorAnnots(Class<?> clazz, List<InterceptorData> stack, boolean isMethod, Method m) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.configureInterceptorAnnots(superClass, stack, false, null);
        }
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundInvoke.class, true, isMethod, stack, m, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundTimeout.class, true, isMethod, stack, m, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PostConstruct.class, true, isMethod, stack, m, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PreDestroy.class, true, isMethod, stack, m, false);
    }

    private void configureBeanAnnots(AnnotatedType annotatedType, List<InterceptorData> stack) {
        Set annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            Class[] intClasses;
            Interceptors incs = (Interceptors)annotatedMethod.getAnnotation(Interceptors.class);
            if (incs == null) continue;
            Method method = annotatedMethod.getJavaMember();
            for (Class intClass : intClasses = incs.value()) {
                this.configureInterceptorAnnots(intClass, stack, true, method);
            }
        }
        Class clazz = annotatedType.getJavaClass();
        List<Class<?>> listSuperClazz = ClassUtil.getSuperClasses(clazz, new ArrayList());
        this.configureBeanSuperClassAnnots(listSuperClazz, stack);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundInvoke.class, false, false, stack, null, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundTimeout.class, false, false, stack, null, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PostConstruct.class, false, false, stack, null, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PreDestroy.class, false, false, stack, null, false);
    }

    private void configureBeanSuperClassAnnots(List<Class<?>> list, List<InterceptorData> stack) {
        int i = list.size();
        for (int j = i - 1; j >= 0; --j) {
            Class<?> clazz = list.get(j);
            if (clazz.equals(Object.class)) continue;
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundInvoke.class, false, false, stack, null, false);
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundTimeout.class, false, false, stack, null, false);
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PostConstruct.class, false, false, stack, null, false);
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PreDestroy.class, false, false, stack, null, false);
        }
    }
}

