/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.module.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.virgo.kernel.module.ModuleContextEvent;
import org.eclipse.virgo.kernel.module.ModuleContextEventListener;
import org.eclipse.virgo.kernel.module.ModuleContextEventPublisher;
import org.eclipse.virgo.nano.core.FatalKernelException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

final class StandardModuleContextEventPublisher
implements ModuleContextEventPublisher {
    private static final String SERVICE_TYPE_PROPERTY_KEY = "objectclass";
    private final Object monitor = new Object();
    private Set<ModuleContextEventListener> listeners = new HashSet<ModuleContextEventListener>();
    private final BundleContext bundleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StandardModuleContextEventPublisher(BundleContext bundleContext) {
        Object object = this.monitor;
        synchronized (object) {
            this.bundleContext = bundleContext;
            try {
                ServiceReference[] allServiceReferences = bundleContext.getAllServiceReferences(ModuleContextEventListener.class.getName(), null);
                if (allServiceReferences != null) {
                    ServiceReference[] serviceReferenceArray = allServiceReferences;
                    int n = allServiceReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ServiceReference serviceReference = serviceReferenceArray[n2];
                        this.registerListener((ServiceReference<ModuleContextEventListener>)serviceReference);
                        ++n2;
                    }
                }
                bundleContext.addServiceListener((ServiceListener)new ListenerListener(), "(objectclass=" + ModuleContextEventListener.class.getName() + ")");
            }
            catch (InvalidSyntaxException e) {
                throw new FatalKernelException("Invalid filter", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListener(ServiceReference<ModuleContextEventListener> serviceReference) {
        Object object = this.monitor;
        synchronized (object) {
            this.listeners.add((ModuleContextEventListener)this.bundleContext.getService(serviceReference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterListener(ServiceReference<ModuleContextEventListener> serviceReference) {
        Object object = this.monitor;
        synchronized (object) {
            this.listeners.remove((ModuleContextEventListener)this.bundleContext.getService(serviceReference));
            this.bundleContext.ungetService(serviceReference);
        }
    }

    @Override
    public void onEvent(ModuleContextEvent moduleContextEvent) {
        for (ModuleContextEventListener moduleContextEventListener : this.getListeners()) {
            moduleContextEventListener.onEvent(moduleContextEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ModuleContextEventListener> getListeners() {
        HashSet<ModuleContextEventListener> l = new HashSet<ModuleContextEventListener>();
        Object object = this.monitor;
        synchronized (object) {
            l.addAll(this.listeners);
        }
        return l;
    }

    private class ListenerListener
    implements ServiceListener {
        private ListenerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            Object object = StandardModuleContextEventPublisher.this.monitor;
            synchronized (object) {
                switch (event.getType()) {
                    case 1: {
                        StandardModuleContextEventPublisher.this.registerListener((ServiceReference<ModuleContextEventListener>)event.getServiceReference());
                        break;
                    }
                    case 4: {
                        StandardModuleContextEventPublisher.this.deregisterListener((ServiceReference<ModuleContextEventListener>)event.getServiceReference());
                        break;
                    }
                }
            }
        }
    }
}

