/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.impl.jdbc.ClobAsciiStream;
import org.apache.derby.impl.jdbc.ClobUpdatableReader;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.StoreStreamClob;
import org.apache.derby.impl.jdbc.TemporaryClob;
import org.apache.derby.impl.jdbc.Util;

final class EmbedClob
extends ConnectionChild
implements Clob,
EngineLOB {
    private InternalClob clob;
    private boolean isValid = true;
    private int locator;

    EmbedClob(EmbedConnection embedConnection) throws SQLException {
        super(embedConnection);
        this.clob = new TemporaryClob(this);
        embedConnection.addLOBReference(this);
    }

    protected EmbedClob(EmbedConnection embedConnection, StringDataValue stringDataValue) throws StandardException {
        super(embedConnection);
        if (stringDataValue.hasStream()) {
            CharacterStreamDescriptor characterStreamDescriptor = stringDataValue.getStreamWithDescriptor();
            try {
                this.clob = new StoreStreamClob(characterStreamDescriptor, this);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("40XD0")) {
                    throw StandardException.newException("XJ073.S");
                }
                throw standardException;
            }
        }
        try {
            this.clob = new TemporaryClob(stringDataValue.getString(), this);
        }
        catch (SQLException sQLException) {
            throw StandardException.newException(sQLException.getSQLState(), sQLException);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XJ022.S", iOException);
        }
        embedConnection.addLOBReference(this);
    }

    public long length() throws SQLException {
        this.checkValidity();
        try {
            return this.clob.getCharLength();
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    public String getSubString(long l, int n) throws SQLException {
        String string;
        this.checkValidity();
        if (l < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        if (n < 0) {
            throw Util.generateCsSQLException("XJ071.S", new Integer(n));
        }
        try {
            int n2;
            int n3;
            Reader reader;
            try {
                reader = this.clob.getInternalReader(l);
            }
            catch (EOFException eOFException) {
                throw Util.generateCsSQLException("XJ076.S", (Object)new Long(l), eOFException);
            }
            char[] cArray = new char[n];
            for (n2 = 0; n2 < n && (n3 = reader.read(cArray, n2, n - n2)) != -1; n2 += n3) {
            }
            reader.close();
            string = n2 == 0 ? "" : String.copyValueOf(cArray, 0, n2);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        return string;
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkValidity();
        try {
            return new ClobUpdatableReader(this);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        return new ReaderToAscii(this.getCharacterStream());
    }

    /*
     * Exception decompiling
     */
    public long position(String var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long position(Clob var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.checkValidity();
        if (l < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        if (l > this.length() + 1L) {
            throw Util.generateCsSQLException("XJ076.S");
        }
        if (string == null) {
            throw Util.generateCsSQLException("XJ072.S");
        }
        if (string.length() == 0) {
            return 0;
        }
        if (n < 0 || n >= string.length()) {
            throw Util.generateCsSQLException("XJ078.S");
        }
        if (n2 < 0) {
            throw Util.generateCsSQLException("XJ071.S");
        }
        if (n2 + n > string.length()) {
            throw Util.generateCsSQLException("22011.S.1", new Integer(n), new Integer(n2), string);
        }
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone();
            }
            this.clob.insertString(string.substring(n, n + n2), l);
        }
        catch (EOFException eOFException) {
            throw Util.generateCsSQLException("XJ076.S", new Long(l));
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
        return string.length();
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        this.checkValidity();
        try {
            return new ClobAsciiStream(this.clob.getWriter(l));
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    public Writer setCharacterStream(long l) throws SQLException {
        this.checkValidity();
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone();
            }
            return this.clob.getWriter(l);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    public void truncate(long l) throws SQLException {
        this.checkValidity();
        if (l < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(l));
        }
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone(l);
            } else {
                this.clob.truncate(l);
            }
        }
        catch (EOFException eOFException) {
            throw Util.generateCsSQLException("XJ079.S", (Object)new Long(l), eOFException);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    public void free() throws SQLException {
        if (this.isValid) {
            this.isValid = false;
            try {
                this.clob.release();
            }
            catch (IOException iOException) {
                throw Util.setStreamFailure(iOException);
            }
            finally {
                this.localConn.removeLOBMapping(this.locator);
                this.clob = null;
            }
        }
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        this.checkValidity();
        if (l <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(l));
        }
        if (l2 < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(l2));
        }
        if (l2 > this.length() - (l - 1L)) {
            throw Util.generateCsSQLException("XJ087.S", (Object)new Long(l), new Long(l2));
        }
        try {
            return new ClobUpdatableReader(this, l, l2);
        }
        catch (IOException iOException) {
            throw Util.setStreamFailure(iOException);
        }
    }

    private void checkValidity() throws SQLException {
        this.localConn.checkIfClosed();
        if (!this.isValid) {
            throw this.newSQLException("XJ215.S");
        }
    }

    private void makeWritableClobClone() throws IOException, SQLException {
        InternalClob internalClob = this.clob;
        this.clob = TemporaryClob.cloneClobContent(this.getEmbedConnection().getDBName(), this, internalClob);
        internalClob.release();
    }

    private void makeWritableClobClone(long l) throws IOException, SQLException {
        InternalClob internalClob = this.clob;
        this.clob = TemporaryClob.cloneClobContent(this.getEmbedConnection().getDBName(), this, internalClob, l);
        internalClob.release();
    }

    InternalClob getInternalClob() {
        return this.clob;
    }

    public int getLocator() {
        if (this.locator == 0) {
            this.locator = this.localConn.addLOBMapping(this);
        }
        return this.locator;
    }
}

