/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.ArtifactSpecification;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.artifact.internal.PlanMemberCollector;
import org.eclipse.virgo.kernel.install.artifact.internal.PlanScoper;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ArtifactIdentityScoper;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.nano.shim.scope.Scope;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.eclipse.virgo.util.common.GraphNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardPlanInstallArtifact
extends AbstractInstallArtifact
implements PlanInstallArtifact {
    private static final Logger LOGGER;
    private final Object monitor;
    private final ScopeServiceRepository scopeServiceRepository;
    private final ScopeFactory scopeFactory;
    private final InstallArtifactRefreshHandler refreshHandler;
    private final boolean atomic;
    private final boolean scoped;
    private final PlanDescriptor.Provisioning provisioning;
    private final List<ArtifactSpecification> artifactSpecifications;
    protected final EventLogger eventLogger;
    private Scope applicationScope;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        Factory factory = new Factory("StandardPlanInstallArtifact.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "policeNestedScopes", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:boolean:org.eclipse.virgo.medic.eventlog.EventLogger:", "artifactIdentity:scoped:eventLogger:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 94);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14", "doStart", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "org.eclipse.virgo.nano.core.AbortableSignal:", "signal:", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 114);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "isScoped", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "", "", "", "boolean"), 226);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14", "doStop", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 140);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14", "doUninstall", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 158);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "inUse", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "org.eclipse.virgo.util.common.GraphNode:", "child:", "", "boolean"), 179);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "scope", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "void"), 185);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deScope", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "", "", "", "void"), 199);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshScope", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "", "", "", "boolean"), 212);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "", "", "org.eclipse.virgo.nano.deployer.api.core.DeploymentException:", "boolean"), 217);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "isAtomic", "org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact", "", "", "", "boolean"), 222);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact");
        LOGGER = LoggerFactory.getLogger(StandardPlanInstallArtifact.class);
    }

    protected StandardPlanInstallArtifact(@NonNull ArtifactIdentity artifactIdentity, boolean atomic, boolean scoped, @NonNull PlanDescriptor.Provisioning provisioning, @NonNull ArtifactStorage artifactStorage, @NonNull ArtifactStateMonitor artifactStateMonitor, @NonNull ScopeServiceRepository scopeServiceRepository, @NonNull ScopeFactory scopeFactory, @NonNull EventLogger eventLogger, @NonNull InstallArtifactRefreshHandler refreshHandler, String repositoryName, List<ArtifactSpecification> artifactSpecifications) throws DeploymentException {
        ArtifactStateMonitor artifactStateMonitor2 = artifactStateMonitor;
        ArtifactStorage artifactStorage2 = artifactStorage;
        PlanDescriptor.Provisioning provisioning2 = provisioning;
        ArtifactIdentity artifactIdentity2 = artifactIdentity;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)artifactIdentity2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)provisioning2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$5$e9cfb671((Object)artifactStorage2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$6$2b4b16f2((Object)artifactStateMonitor2);
        super(artifactIdentity, artifactStorage, artifactStateMonitor, repositoryName, eventLogger);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.monitor = new Object();
            this.policeNestedScopes(artifactIdentity, scoped, eventLogger);
            this.scopeServiceRepository = scopeServiceRepository;
            this.scopeFactory = scopeFactory;
            this.eventLogger = eventLogger;
            this.refreshHandler = refreshHandler;
            this.atomic = atomic;
            this.scoped = scoped;
            if (provisioning == PlanDescriptor.Provisioning.INHERIT) {
                throw new IllegalArgumentException("A plan's provisoning behaviour may not be set to INHERIT");
            }
            this.provisioning = provisioning;
            this.artifactSpecifications = artifactSpecifications;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void policeNestedScopes(ArtifactIdentity artifactIdentity, boolean scoped, EventLogger eventLogger) throws DeploymentException {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                if (artifactIdentity.getScopeName() != null && scoped) {
                    eventLogger.log((LogEvent)DeployerLogEvents.NESTED_SCOPES_NOT_SUPPORTED, new Object[]{artifactIdentity.getType(), ArtifactIdentityScoper.getUnscopedName(artifactIdentity), artifactIdentity.getVersion(), artifactIdentity.getScopeName()});
                    throw new DeploymentException("Nested scope detected", true);
                }
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<GraphNode<InstallArtifact>> getChildrenSnapshot() {
        try {
            ArrayList<GraphNode<InstallArtifact>> children = new ArrayList<GraphNode<InstallArtifact>>();
            Object object = this.monitor;
            synchronized (object) {
                children.addAll(this.getGraph().getChildren());
            }
            return children;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final void doStart(AbortableSignal signal) throws DeploymentException {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                List<GraphNode<InstallArtifact>> children = this.getChildrenSnapshot();
                int numChildren = children.size();
                AbortableSignalJunction signalJunction = new AbortableSignalJunction(signal, numChildren);
                LOGGER.debug("Created {} that will notify {} to track start of {}", new Object[]{signalJunction, signal, this});
                List<AbortableSignal> subSignals = signalJunction.getSignals();
                int childIndex = 0;
                while (true) {
                    block8: {
                        block7: {
                            if (childIndex >= numChildren) break block7;
                            if (!signalJunction.failed()) break block8;
                        }
                        StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                        return;
                    }
                    InstallArtifact childArtifact = (InstallArtifact)children.get(childIndex).getValue();
                    AbortableSignal subSignal = subSignals.get(childIndex);
                    LOGGER.debug("Starting {} with signal {} from {}", new Object[]{childArtifact, subSignal, signalJunction});
                    childArtifact.start(subSignal);
                    ++childIndex;
                }
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    protected final void doStop() throws DeploymentException {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                DeploymentException firstFailure = null;
                for (GraphNode<InstallArtifact> child : this.getChildrenSnapshot()) {
                    try {
                        ((InstallArtifact)child.getValue()).stop();
                    }
                    catch (DeploymentException e) {
                        firstFailure = e;
                    }
                }
                if (firstFailure != null) {
                    throw firstFailure;
                }
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    protected final void doUninstall() throws DeploymentException {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                this.deScope();
                DeploymentException firstFailure = null;
                for (GraphNode<InstallArtifact> child : this.getChildrenSnapshot()) {
                    this.getGraph().removeChild(child);
                    if (this.inUse(child)) continue;
                    try {
                        ((InstallArtifact)child.getValue()).uninstall();
                    }
                    catch (DeploymentException e) {
                        firstFailure = e;
                    }
                }
                if (firstFailure != null) {
                    throw firstFailure;
                }
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean inUse(GraphNode<InstallArtifact> child) {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                AbstractInstallArtifact installArtifact = (AbstractInstallArtifact)child.getValue();
                boolean isTopLevelDeployed = installArtifact.getTopLevelDeployed();
                boolean bl = isTopLevelDeployed || !child.getParents().isEmpty();
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return bl;
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scope() throws DeploymentException {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
                if (this.isScoped()) {
                    List<InstallArtifact> scopeMembers = new PlanMemberCollector().collectPlanMembers(this);
                    PlanScoper planScoper = new PlanScoper(scopeMembers, this.getName(), this.getVersion(), this.scopeServiceRepository, this.eventLogger);
                    String scopeName = planScoper.getScopeName();
                    Object object = this.monitor;
                    synchronized (object) {
                        this.applicationScope = this.scopeFactory.getApplicationScope(scopeName);
                        planScoper.scope();
                    }
                }
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deScope() {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                Object object = this.monitor;
                synchronized (object) {
                    if (this.applicationScope != null) {
                        this.scopeFactory.destroyApplicationScope(this.applicationScope);
                        this.scopeServiceRepository.clearScope(this.applicationScope.getScopeName());
                        this.applicationScope = null;
                    }
                }
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public boolean refreshScope() {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_7);
                boolean bl = this.refreshHandler.refresh(this);
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_7);
                return bl;
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public boolean refresh() throws DeploymentException {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_8);
                this.eventLogger.log((LogEvent)DeployerLogEvents.INSTALL_ARTIFACT_REFRESH_NOT_SUPPORTED, new Object[]{this.getType(), this.getName(), this.getVersion(), this.getType()});
                boolean bl = false;
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_8);
                return bl;
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_8);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final boolean isAtomic() {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_9);
                boolean bl = this.atomic;
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_9);
                return bl;
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_9);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final boolean isScoped() {
        try {
            try {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_10);
                boolean bl = this.scoped;
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_10);
                return bl;
            }
            catch (Throwable throwable) {
                StandardPlanInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_10);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public PlanDescriptor.Provisioning getProvisioning() {
        try {
            return this.provisioning;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final List<ArtifactSpecification> getArtifactSpecifications() {
        try {
            return this.artifactSpecifications;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

