/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.openejb.util.URLs;

public class UrlComparator
implements Comparator<URL> {
    private File dir;
    private List<String> rootPath;

    public UrlComparator(File directory) {
        this.dir = directory;
        this.rootPath = this.path(this.dir);
    }

    public UrlComparator(URL base) {
        this(URLs.toFile(base));
    }

    @Override
    public int compare(URL a, URL b) {
        return this.score(b) - this.score(a);
    }

    private int score(URL url) {
        String nameB;
        String nameA;
        File file = URLs.toFile(url);
        List<String> filePath = this.path(file);
        int matches = 0;
        ListIterator<String> a = this.rootPath.listIterator();
        ListIterator<String> b = filePath.listIterator();
        while (a.hasNext() && b.hasNext() && (nameA = a.next()).equals(nameB = b.next())) {
            ++matches;
        }
        return matches;
    }

    private List<String> path(File file) {
        ArrayList<String> path = new ArrayList<String>();
        this.path(file, path);
        return path;
    }

    private void path(File file, List<String> path) {
        if (file == null) {
            return;
        }
        this.path(file.getParentFile(), path);
        path.add(file.getName());
    }
}

