/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.core.internal;

import java.lang.management.ManagementFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.config.internal.ConfigurationInitialiser;
import org.eclipse.virgo.nano.config.internal.KernelConfiguration;
import org.eclipse.virgo.nano.core.BundleStarter;
import org.eclipse.virgo.nano.core.Shutdown;
import org.eclipse.virgo.nano.core.internal.AsyncShutdownDecorator;
import org.eclipse.virgo.nano.core.internal.BundleStartTracker;
import org.eclipse.virgo.nano.core.internal.ShutdownManager;
import org.eclipse.virgo.nano.core.internal.StandardBundleStarter;
import org.eclipse.virgo.nano.core.internal.StartupTracker;
import org.eclipse.virgo.nano.core.internal.blueprint.ApplicationContextDependencyMonitor;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.dump.internal.RegionDigraphDumpContributor;
import org.eclipse.virgo.nano.serviceability.dump.internal.ResolutionDumpContributor;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.eclipse.virgo.nano.shim.scope.internal.StandardScopeFactory;
import org.eclipse.virgo.nano.shim.serviceability.TracingService;
import org.eclipse.virgo.nano.shim.serviceability.internal.Slf4jTracingService;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventHandler;

public class CoreBundleActivator {
    private static final String START_SIGNALLING_THREAD_NAME_PREFIX = "start-signalling-";
    private static final String PROPERTY_NAME_SERVICE_SCOPE = "org.eclipse.virgo.service.scope";
    private static final String SERVICE_SCOPE_GLOBAL = "global";
    private static final String EVENT_TOPIC_BLUEPRINT_CONTAINER = "org/osgi/service/blueprint/container/*";
    private static final String EVENT_TOPIC_REGION = "org/eclipse/virgo/kernel/region/*";
    private static final String MBEAN_VALUE_SHUTDOWN = "Shutdown";
    private static final String MBEAN_KEY_TYPE = "type";
    private final ServiceRegistrationTracker tracker;
    private final ConfigurationInitialiser configurationInitialiser;
    private volatile StartupTracker startupTracker;
    private volatile ObjectInstance shutdownMBean;
    private volatile ApplicationContextDependencyMonitor dependencyMonitor;
    private volatile BundleStartTracker bundleStartTracker;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public CoreBundleActivator() {
        try {
            this.tracker = new ServiceRegistrationTracker();
            this.configurationInitialiser = new ConfigurationInitialiser();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void activate(ComponentContext componentContext) throws Exception {
        try {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                BundleContext context = componentContext.getBundleContext();
                EventLogger eventLogger = this.getRequiredService(context, EventLogger.class);
                KernelConfiguration configuration = this.configurationInitialiser.start(context, eventLogger);
                Shutdown shutdown = this.initializeShutdownManager(context, eventLogger, configuration);
                this.bundleStartTracker = this.createAndRegisterBundleStartTracker(context);
                this.createAndRegisterBundleStarter(this.bundleStartTracker, context);
                this.dependencyMonitor = this.createAndRegisterApplicationContextDependencyMonitor(context, eventLogger);
                DumpGenerator dumpGenerator = this.getRequiredService(context, DumpGenerator.class);
                this.createAndRegisterStateDumpContributors(context);
                this.startupTracker = new StartupTracker(context, configuration, configuration.getStartupWaitLimit(), this.bundleStartTracker, shutdown, dumpGenerator);
                this.startupTracker.start();
                this.initShimServices(context, eventLogger);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private void createAndRegisterStateDumpContributors(BundleContext context) {
        try {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                this.tracker.track(context.registerService(DumpContributor.class, (Object)new ResolutionDumpContributor(context), null));
                this.tracker.track(context.registerService(DumpContributor.class, (Object)new RegionDigraphDumpContributor(context), null));
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private ApplicationContextDependencyMonitor createAndRegisterApplicationContextDependencyMonitor(BundleContext context, EventLogger eventLogger) {
        try {
            ApplicationContextDependencyMonitor applicationContextDependencyMonitor;
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){
                    private AtomicLong threadCount;
                    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                    {
                        try {
                            try {
                            }
                            catch (RuntimeException runtimeException) {
                                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                throw runtimeException;
                            }
                            this.threadCount = new AtomicLong(1L);
                            return;
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                    }

                    @Override
                    public Thread newThread(Runnable r) {
                        try {
                            Thread thread;
                            1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                            try {
                                String name = "service-monitor-thread-" + this.threadCount.getAndIncrement();
                                thread = new Thread(r, name);
                            }
                            catch (RuntimeException runtimeException) {
                                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                throw runtimeException;
                            }
                            1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                            return thread;
                        }
                        catch (Throwable throwable) {
                            1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                            throw throwable;
                        }
                    }

                    static {
                        Factory factory = new Factory("CoreBundleActivator.java", Class.forName("org.eclipse.virgo.nano.core.internal.CoreBundleActivator$1"));
                        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newThread", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator$1", "java.lang.Runnable:", "r:", "", "java.lang.Thread"), 122);
                        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.nano.core.internal.CoreBundleActivator$1");
                    }
                });
                ApplicationContextDependencyMonitor dependencyMonitor = new ApplicationContextDependencyMonitor(scheduledExecutor, eventLogger);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("event.topics", EVENT_TOPIC_BLUEPRINT_CONTAINER);
                this.tracker.track(context.registerService(EventHandler.class.getName(), (Object)dependencyMonitor, properties));
                applicationContextDependencyMonitor = dependencyMonitor;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return applicationContextDependencyMonitor;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private BundleStartTracker createAndRegisterBundleStartTracker(BundleContext context) {
        try {
            BundleStartTracker bundleStartTracker;
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                SynchronousQueue<Runnable> q = new SynchronousQueue<Runnable>();
                ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, q, new PrefixingThreadFactory(START_SIGNALLING_THREAD_NAME_PREFIX), new ThreadPoolExecutor.AbortPolicy());
                BundleStartTracker asynchronousStartTracker = new BundleStartTracker(executor);
                asynchronousStartTracker.initialize(context);
                Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
                ((Dictionary)properties).put("event.topics", new String[]{EVENT_TOPIC_BLUEPRINT_CONTAINER, EVENT_TOPIC_REGION});
                this.tracker.track(context.registerService(new String[]{EventHandler.class.getName()}, (Object)asynchronousStartTracker, properties));
                bundleStartTracker = asynchronousStartTracker;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return bundleStartTracker;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private BundleStarter createAndRegisterBundleStarter(BundleStartTracker asynchronousStartTracker, BundleContext bundleContext) {
        try {
            StandardBundleStarter standardBundleStarter;
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            try {
                StandardBundleStarter bundleStarter = new StandardBundleStarter(asynchronousStartTracker);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put(PROPERTY_NAME_SERVICE_SCOPE, SERVICE_SCOPE_GLOBAL);
                this.tracker.track(bundleContext.registerService(new String[]{BundleStarter.class.getName()}, (Object)bundleStarter, properties));
                standardBundleStarter = bundleStarter;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return standardBundleStarter;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        try {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            try {
                BundleStartTracker bundleStartTracker;
                this.tracker.unregisterAll();
                this.startupTracker.stop();
                this.configurationInitialiser.stop();
                this.unregisterShutdownMBean();
                ApplicationContextDependencyMonitor dependencyMonitor = this.dependencyMonitor;
                if (dependencyMonitor != null) {
                    this.dependencyMonitor = null;
                    dependencyMonitor.stop();
                }
                if ((bundleStartTracker = this.bundleStartTracker) != null) {
                    this.bundleStartTracker = null;
                    bundleStartTracker.stop();
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private Shutdown initializeShutdownManager(BundleContext context, EventLogger eventLogger, KernelConfiguration configuration) {
        try {
            Shutdown shutdown;
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            try {
                Shutdown shutdown2 = this.createShutdown(context, eventLogger);
                this.tracker.track(context.registerService(Shutdown.class.getName(), (Object)shutdown2, null));
                this.registerShutdownMBean(configuration, shutdown2);
                shutdown = shutdown2;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return shutdown;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private void registerShutdownMBean(KernelConfiguration configuration, Shutdown shutdown) {
        try {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                try {
                    ObjectName shutdownName = ObjectName.getInstance(configuration.getDomain(), MBEAN_KEY_TYPE, MBEAN_VALUE_SHUTDOWN);
                    this.shutdownMBean = server.registerMBean(new AsyncShutdownDecorator(shutdown), shutdownName);
                }
                catch (JMException ex) {
                    throw new IllegalStateException("Unable to register Shutdown MBean", ex);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    private void unregisterShutdownMBean() throws MBeanRegistrationException, InstanceNotFoundException {
        try {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
            try {
                ObjectInstance localShutdownMBean = this.shutdownMBean;
                if (localShutdownMBean != null) {
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(localShutdownMBean.getObjectName());
                    this.shutdownMBean = null;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    protected Shutdown createShutdown(BundleContext context, EventLogger eventLogger) {
        try {
            ShutdownManager shutdownManager;
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
            try {
                ShutdownManager manager;
                Framework framework = (Framework)context.getBundle(0L);
                shutdownManager = manager = new ShutdownManager(eventLogger, framework);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
            return shutdownManager;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    private void initShimServices(BundleContext context, EventLogger eventLogger) {
        try {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_10);
            try {
                StandardScopeFactory scopeFactory = new StandardScopeFactory(eventLogger);
                Slf4jTracingService tracingService = new Slf4jTracingService();
                this.tracker.track(context.registerService(ScopeFactory.class.getName(), (Object)scopeFactory, null));
                this.tracker.track(context.registerService(TracingService.class.getName(), (Object)tracingService, null));
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_10);
            return;
        }
        catch (Throwable throwable) {
            CoreBundleActivator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_10);
            throw throwable;
        }
    }

    private <T> T getRequiredService(BundleContext context, Class<T> clazz) {
        try {
            Object result = null;
            ServiceReference ref = context.getServiceReference(clazz.getName());
            if (ref != null) {
                result = context.getService(ref);
            }
            if (result == null) {
                throw new IllegalStateException("Unable to access required service of type '" + clazz.getName() + "' from bundle '" + context.getBundle().getSymbolicName() + "'");
            }
            return (T)result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("CoreBundleActivator.java", Class.forName("org.eclipse.virgo.nano.core.internal.CoreBundleActivator"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "activate", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "org.osgi.service.component.ComponentContext:", "componentContext:", "java.lang.Exception:", "void"), 90);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createAndRegisterStateDumpContributors", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "org.osgi.framework.BundleContext:", "context:", "", "void"), 113);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initShimServices", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "org.osgi.framework.BundleContext:org.eclipse.virgo.medic.eventlog.EventLogger:", "context:eventLogger:", "", "void"), 219);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createAndRegisterApplicationContextDependencyMonitor", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "org.osgi.framework.BundleContext:org.eclipse.virgo.medic.eventlog.EventLogger:", "context:eventLogger:", "", "org.eclipse.virgo.nano.core.internal.blueprint.ApplicationContextDependencyMonitor"), 118);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createAndRegisterBundleStartTracker", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "org.osgi.framework.BundleContext:", "context:", "", "org.eclipse.virgo.nano.core.internal.BundleStartTracker"), 139);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createAndRegisterBundleStarter", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "org.eclipse.virgo.nano.core.internal.BundleStartTracker:org.osgi.framework.BundleContext:", "asynchronousStartTracker:bundleContext:", "", "org.eclipse.virgo.nano.core.BundleStarter"), 154);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deactivate", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "org.osgi.service.component.ComponentContext:", "context:", "java.lang.Exception:", "void"), 165);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeShutdownManager", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "org.osgi.framework.BundleContext:org.eclipse.virgo.medic.eventlog.EventLogger:org.eclipse.virgo.nano.config.internal.KernelConfiguration:", "context:eventLogger:configuration:", "", "org.eclipse.virgo.nano.core.Shutdown"), 185);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerShutdownMBean", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "org.eclipse.virgo.nano.config.internal.KernelConfiguration:org.eclipse.virgo.nano.core.Shutdown:", "configuration:shutdown:", "", "void"), 193);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "unregisterShutdownMBean", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "", "", "javax.management.MBeanRegistrationException:javax.management.InstanceNotFoundException:", "void"), 204);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createShutdown", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator", "org.osgi.framework.BundleContext:org.eclipse.virgo.medic.eventlog.EventLogger:", "context:eventLogger:", "", "org.eclipse.virgo.nano.core.Shutdown"), 212);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.nano.core.internal.CoreBundleActivator");
    }

    private class PrefixingThreadFactory
    implements ThreadFactory {
        private int threadCount;
        private final Object threadCountMonitor;
        String prefix;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public PrefixingThreadFactory(String prefix) {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.threadCount = 0;
                this.threadCountMonitor = new Object();
                this.prefix = "default-thread-prefix";
                this.prefix = prefix;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public Thread newThread(Runnable r) {
            try {
                Thread thread;
                PrefixingThreadFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                try {
                    thread = new Thread(r, this.nextThreadName());
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                PrefixingThreadFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return thread;
            }
            catch (Throwable throwable) {
                PrefixingThreadFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String nextThreadName() {
            try {
                String string;
                PrefixingThreadFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                try {
                    int threadNumber = 0;
                    Object object = this.threadCountMonitor;
                    synchronized (object) {
                        ++this.threadCount;
                        threadNumber = this.threadCount;
                    }
                    string = String.valueOf(this.prefix) + threadNumber;
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                PrefixingThreadFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return string;
            }
            catch (Throwable throwable) {
                PrefixingThreadFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("CoreBundleActivator.java", Class.forName("org.eclipse.virgo.nano.core.internal.CoreBundleActivator$PrefixingThreadFactory"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newThread", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator$PrefixingThreadFactory", "java.lang.Runnable:", "r:", "", "java.lang.Thread"), 250);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "nextThreadName", "org.eclipse.virgo.nano.core.internal.CoreBundleActivator$PrefixingThreadFactory", "", "", "", "java.lang.String"), 254);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.nano.core.internal.CoreBundleActivator$PrefixingThreadFactory");
        }
    }
}

