/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.config.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.config.internal.PropertiesSource;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.IterableEnumeration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

final class ConfigurationPublisher {
    private final ConfigurationAdmin configAdmin;
    private final PropertiesSource[] sources;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    ConfigurationPublisher(ConfigurationAdmin configAdmin, PropertiesSource ... sources) {
        try {
            this.configAdmin = configAdmin;
            this.sources = sources == null ? new PropertiesSource[]{} : sources;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void publishConfigurations() throws IOException {
        try {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            try {
                PropertiesSource[] propertiesSourceArray = this.sources;
                int n = this.sources.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertiesSource source = propertiesSourceArray[n2];
                    Map<String, Properties> configurationProperties = source.getConfigurationProperties();
                    if (configurationProperties != null) {
                        for (Map.Entry<String, Properties> entry : configurationProperties.entrySet()) {
                            this.populateConfigurationWithProperties(entry.getKey(), entry.getValue());
                        }
                    }
                    ++n2;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void populateConfigurationWithProperties(@NonNull String string, @NonNull Properties properties) throws IOException {
        Properties properties2 = properties;
        String string2 = string;
        try {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                void properties3;
                void pid;
                NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8(string2);
                NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82(properties2);
                Configuration config = this.configAdmin.getConfiguration((String)pid, null);
                Hashtable configProperties = config.getProperties();
                if (configProperties == null) {
                    configProperties = new Hashtable();
                }
                for (Object key : new IterableEnumeration(properties3.keys())) {
                    Object value = properties3.get(key);
                    ((Dictionary)configProperties).put(key, value);
                }
                config.update(configProperties);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationPublisher.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ConfigurationPublisher.java", Class.forName("org.eclipse.virgo.kernel.config.internal.ConfigurationPublisher"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "publishConfigurations", "org.eclipse.virgo.kernel.config.internal.ConfigurationPublisher", "", "", "java.io.IOException:", "void"), 53);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "populateConfigurationWithProperties", "org.eclipse.virgo.kernel.config.internal.ConfigurationPublisher", "java.lang.String:java.util.Properties:", "pid:properties:", "java.io.IOException:", "void"), 66);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.config.internal.ConfigurationPublisher");
    }
}

