/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.properties;

import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.eclipse.virgo.repository.HashGenerator;
import org.eclipse.virgo.repository.builder.ArtifactDescriptorBuilder;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.Version;

public final class PropertiesBridge
implements ArtifactBridge {
    static final String PROPERTIES_SUFFIX = ".properties";
    static final String ARTIFACT_TYPE = "configuration";
    private final HashGenerator hashGenerator;

    public PropertiesBridge(HashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public ArtifactDescriptor generateArtifactDescriptor(File artifactFile) throws ArtifactGenerationException {
        if (artifactFile.getName().endsWith(PROPERTIES_SUFFIX)) {
            ArtifactDescriptor artifactDescriptor;
            FileReader reader = null;
            try {
                reader = new FileReader(artifactFile);
                new Properties().load(reader);
                artifactDescriptor = this.createArtifactDescriptor(artifactFile);
            }
            catch (IOException e) {
                try {
                    throw new ArtifactGenerationException("Failed to read properties file", ARTIFACT_TYPE, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)reader);
            return artifactDescriptor;
        }
        return null;
    }

    private ArtifactDescriptor createArtifactDescriptor(File propertiesFile) {
        String fileName = propertiesFile.getName();
        String name = fileName.substring(0, fileName.length() - PROPERTIES_SUFFIX.length());
        ArtifactDescriptorBuilder artifactDescriptorBuilder = new ArtifactDescriptorBuilder();
        artifactDescriptorBuilder.setUri(propertiesFile.toURI()).setType(ARTIFACT_TYPE).setName(name).setVersion(Version.emptyVersion);
        this.hashGenerator.generateHash(artifactDescriptorBuilder, propertiesFile);
        return artifactDescriptorBuilder.build();
    }
}

