/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionDigraphVisitor;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

final class BundleIdBasedRegion
implements Region {
    private static final String REGION_LOCATION_DELIMITER = "@";
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String FILE_SCHEME = "file:";
    private final Object globalUpdateMonitor;
    private final AtomicLong globalTimeStamp;
    private final Map<Long, Region> globalBundleToRegion;
    private final String regionName;
    private final RegionDigraph regionDigraph;
    private final BundleContext bundleContext;
    private final ThreadLocal<Region> threadLocal;

    BundleIdBasedRegion(String regionName, RegionDigraph regionDigraph, BundleContext bundleContext, ThreadLocal<Region> threadLocal, Object globalUpdateMonitor, AtomicLong globalTimeStamp, Map<Long, Region> globalBundleToRegion) {
        if (regionName == null) {
            throw new IllegalArgumentException("The region name must not be null");
        }
        if (regionDigraph == null) {
            throw new IllegalArgumentException("The region digraph must not be null");
        }
        if (globalUpdateMonitor == null) {
            throw new IllegalArgumentException("The global update monitor must not be null");
        }
        if (globalBundleToRegion == null) {
            throw new IllegalArgumentException("The global bundle to region must not be null");
        }
        this.regionName = regionName;
        this.regionDigraph = regionDigraph;
        this.bundleContext = bundleContext;
        this.threadLocal = threadLocal;
        this.globalUpdateMonitor = globalUpdateMonitor;
        this.globalTimeStamp = globalTimeStamp;
        this.globalBundleToRegion = globalBundleToRegion;
    }

    @Override
    public String getName() {
        return this.regionName;
    }

    @Override
    public void addBundle(Bundle bundle) throws BundleException {
        this.addBundle(bundle.getBundleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBundle(long bundleId) throws BundleException {
        Object object = this.globalUpdateMonitor;
        synchronized (object) {
            Region r = this.globalBundleToRegion.get(bundleId);
            if (r != null && r != this) {
                throw new BundleException("Bundle '" + bundleId + "' is already associated with region '" + r + "'", 2);
            }
            this.globalBundleToRegion.put(bundleId, this);
            this.globalTimeStamp.incrementAndGet();
        }
    }

    @Override
    public Bundle installBundle(String location, InputStream input) throws BundleException {
        if (this.bundleContext == null) {
            throw new BundleException("This region is not connected to an OSGi Framework.", 2);
        }
        this.setRegionThreadLocal();
        try {
            Bundle bundle = this.bundleContext.installBundle(String.valueOf(this.regionName) + REGION_LOCATION_DELIMITER + location, input);
            return bundle;
        }
        finally {
            this.removeRegionThreadLocal();
        }
    }

    @Override
    public Bundle installBundle(String location) throws BundleException {
        if (this.bundleContext == null) {
            throw new BundleException("This region is not connected to an OSGi Framework.", 2);
        }
        this.setRegionThreadLocal();
        try {
            Bundle bundle = this.bundleContext.installBundle(String.valueOf(this.regionName) + REGION_LOCATION_DELIMITER + location, this.openBundleStream(location));
            return bundle;
        }
        finally {
            this.removeRegionThreadLocal();
        }
    }

    private void setRegionThreadLocal() {
        if (this.threadLocal != null) {
            this.threadLocal.set(this);
        }
    }

    private void removeRegionThreadLocal() {
        if (this.threadLocal != null) {
            this.threadLocal.remove();
        }
    }

    private InputStream openBundleStream(String location) throws BundleException {
        String absoluteBundleReferenceUriString = location.startsWith(REFERENCE_SCHEME) ? location : REFERENCE_SCHEME + this.getAbsoluteUriString(location);
        try {
            return new URL(absoluteBundleReferenceUriString).openStream();
        }
        catch (MalformedURLException e) {
            throw new BundleException("Location '" + location + "' resulted in an invalid bundle URI '" + absoluteBundleReferenceUriString + "'", (Throwable)e);
        }
        catch (IOException e) {
            throw new BundleException("Location '" + location + "' referred to an invalid bundle at URI '" + absoluteBundleReferenceUriString + "'", (Throwable)e);
        }
    }

    private String getAbsoluteUriString(String location) throws BundleException {
        if (!location.startsWith(FILE_SCHEME)) {
            throw new BundleException("Cannot install from location '" + location + "' which did not start with '" + FILE_SCHEME + "'");
        }
        String filePath = location.substring(FILE_SCHEME.length());
        return FILE_SCHEME + new File(filePath).getAbsolutePath();
    }

    @Override
    public Bundle getBundle(String symbolicName, Version version) {
        if (this.bundleContext == null) {
            return null;
        }
        Set<Long> bundleIds = this.getBundleIds();
        for (long bundleId : bundleIds) {
            Bundle bundle = this.bundleContext.getBundle(bundleId);
            if (bundle == null || !symbolicName.equals(bundle.getSymbolicName()) || !version.equals((Object)bundle.getVersion())) continue;
            return bundle;
        }
        return null;
    }

    @Override
    public void connectRegion(Region headRegion, RegionFilter filter) throws BundleException {
        this.regionDigraph.connect(this, filter, headRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(long bundleId) {
        Object object = this.globalUpdateMonitor;
        synchronized (object) {
            return this.globalBundleToRegion.get(bundleId) == this;
        }
    }

    @Override
    public boolean contains(Bundle bundle) {
        return this.contains(bundle.getBundleId());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.regionName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleIdBasedRegion)) {
            return false;
        }
        BundleIdBasedRegion other = (BundleIdBasedRegion)obj;
        return this.regionName.equals(other.regionName);
    }

    @Override
    public void removeBundle(Bundle bundle) {
        this.removeBundle(bundle.getBundleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundle(long bundleId) {
        Object object = this.globalUpdateMonitor;
        synchronized (object) {
            this.globalBundleToRegion.remove(bundleId);
            this.globalTimeStamp.incrementAndGet();
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getBundleIds() {
        HashSet<Long> bundleIds = new HashSet<Long>();
        Object object = this.globalUpdateMonitor;
        synchronized (object) {
            for (Map.Entry<Long, Region> entry : this.globalBundleToRegion.entrySet()) {
                if (entry.getValue() != this) continue;
                bundleIds.add(entry.getKey());
            }
        }
        return bundleIds;
    }

    @Override
    public Set<RegionDigraph.FilteredRegion> getEdges() {
        return this.regionDigraph.getEdges(this);
    }

    @Override
    public void visitSubgraph(RegionDigraphVisitor visitor) {
        this.regionDigraph.visitSubgraph(this, visitor);
    }

    @Override
    public RegionDigraph getRegionDigraph() {
        return this.regionDigraph;
    }
}

