/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphInclosure;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStorageFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ArtifactIdentityScoper;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.util.common.GraphNode;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardInstallArtifactGraphInclosure
implements InstallArtifactGraphInclosure {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EventLogger eventLogger;
    private final BundleContext bundleContext;
    private final ArtifactStorageFactory artifactStorageFactory;

    public StandardInstallArtifactGraphInclosure(@NonNull ArtifactStorageFactory artifactStorageFactory, @NonNull BundleContext bundleContext, @NonNull EventLogger eventLogger) {
        this.artifactStorageFactory = artifactStorageFactory;
        this.eventLogger = eventLogger;
        this.bundleContext = bundleContext;
    }

    @Override
    public GraphNode<InstallArtifact> constructGraphNode(ArtifactIdentity identity, File artifact, Map<String, String> properties, String repositoryName) throws DeploymentException {
        if (!artifact.exists()) {
            throw new DeploymentException(artifact + " does not exist");
        }
        ArtifactIdentity scopedIdentity = ArtifactIdentityScoper.scopeArtifactIdentity(identity);
        ArtifactStorage artifactStorage = this.artifactStorageFactory.create(artifact, scopedIdentity);
        try {
            return this.constructInstallArtifactGraph(scopedIdentity, properties, artifactStorage, repositoryName);
        }
        catch (DeploymentException e) {
            artifactStorage.delete();
            throw e;
        }
    }

    private GraphNode<InstallArtifact> constructInstallArtifactGraph(ArtifactIdentity identity, Map<String, String> deploymentProperties, ArtifactStorage artifactStorage, String repositoryName) throws DeploymentException {
        GraphNode<InstallArtifact> graph = null;
        List iatfHolders = OsgiFrameworkUtils.getServices((BundleContext)this.bundleContext, InstallArtifactGraphFactory.class);
        for (OsgiServiceHolder iatfHolder : iatfHolders) {
            InstallArtifactGraphFactory iatf = (InstallArtifactGraphFactory)iatfHolder.getService();
            try {
                if (iatf == null || (graph = iatf.constructInstallArtifactGraph(identity, artifactStorage, deploymentProperties, repositoryName)) == null) continue;
                break;
            }
            finally {
                this.bundleContext.ungetService(iatfHolder.getServiceReference());
            }
        }
        if (graph == null) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.MISSING_ARTIFACT_FACTORY, new Object[]{identity.getType(), identity.getName(), identity.getVersion()});
            throw new DeploymentException("Cannot create InstallArtifact for '" + identity + "'");
        }
        return graph;
    }

    @Override
    public GraphNode<InstallArtifact> recoverInstallGraph(ArtifactIdentity artifactIdentity, File artifact) {
        ArtifactStorage artifactStorage = null;
        try {
            artifactStorage = this.artifactStorageFactory.create(artifact, artifactIdentity);
            GraphNode<InstallArtifact> installArtifactGraph = this.constructInstallArtifactGraph(artifactIdentity, null, artifactStorage, null);
            return installArtifactGraph;
        }
        catch (RuntimeException e) {
            if (artifactStorage != null) {
                artifactStorage.delete();
            }
            this.logger.error(String.format("An error occurred during recovery of artefact '%s'", artifact), (Throwable)e);
            throw e;
        }
        catch (DeploymentException e) {
            if (artifactStorage != null) {
                artifactStorage.delete();
            }
            this.logger.warn(String.format("An error occurred during recovery of artefact '%s'", artifact), (Throwable)e);
            return null;
        }
    }
}

