/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.serviceability;

import java.util.Collection;
import java.util.Map;

public final class Assert {
    public static void isTrue(boolean expression, String message, Object ... inserts) {
        if (!expression) {
            throw new FatalAssertionException(String.format(message, inserts));
        }
    }

    public static void isFalse(boolean expression, String message, Object ... inserts) {
        if (expression) {
            throw new FatalAssertionException(String.format(message, inserts));
        }
    }

    public static void isNull(Object object, String message, Object ... inserts) {
        if (object != null) {
            throw new FatalAssertionException(String.format(message, inserts));
        }
    }

    public static void notNull(Object object, String message, Object ... inserts) {
        if (object == null) {
            throw new FatalAssertionException(String.format(message, inserts));
        }
    }

    public static void hasLength(String text, String message, Object ... inserts) {
        if (text == null || text.length() == 0) {
            throw new FatalAssertionException(String.format(message, inserts));
        }
    }

    public static void notEmpty(Object[] array, String message, Object ... inserts) {
        if (array == null || array.length == 0) {
            throw new FatalAssertionException(String.format(message, inserts));
        }
    }

    public static <T> void notEmpty(Collection<T> collection, String message, Object ... inserts) {
        if (collection == null || collection.isEmpty()) {
            throw new FatalAssertionException(String.format(message, inserts));
        }
    }

    public static <K, V> void notEmpty(Map<K, V> map, String message, Object ... inserts) {
        if (map == null || map.isEmpty()) {
            throw new FatalAssertionException(String.format(message, inserts));
        }
    }

    public static <T> void isInstanceOf(Class<T> type, Object obj, String message, Object ... inserts) {
        Assert.notNull(type, "The type to check against must not be null", new Object[0]);
        if (!type.isInstance(obj)) {
            throw new FatalAssertionException(String.valueOf(String.format(message, inserts)) + "Object of class [" + (obj != null ? obj.getClass().getName() : "null") + "] must be an instance of " + type);
        }
    }

    public static <T, U> void isAssignable(Class<T> superType, Class<U> subType, String message, Object ... inserts) {
        Assert.notNull(superType, "Type to check against must not be null", new Object[0]);
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new FatalAssertionException(String.valueOf(String.format(message, inserts)) + subType + " is not assignable to " + superType);
        }
    }

    private Assert() {
    }

    public static final class FatalAssertionException
    extends RuntimeException {
        private static final long serialVersionUID = -4633344457818398425L;

        public FatalAssertionException(String message) {
            super(message);
        }
    }
}

