/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.proxy.MethodHandler;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateHandler
implements InvocationHandler,
MethodHandler,
Serializable,
Externalizable {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(DelegateHandler.class);
    private static final long serialVersionUID = -3063755008944970684L;
    private transient List<Object> decorators;
    public static transient ThreadLocal<AtomicInteger> position = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };
    private transient Object actualInstance = null;
    private transient OwbBean<?> bean = null;
    private transient InvocationContext ejbContext;

    public DelegateHandler() {
    }

    public DelegateHandler(OwbBean<?> bean) {
        this.bean = bean;
    }

    public DelegateHandler(OwbBean<?> bean, InvocationContext ejbContext) {
        this.bean = bean;
        this.ejbContext = ejbContext;
    }

    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments) throws Exception {
        return this.invoke(instance, method, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object instance, Method method, Object[] arguments) throws Exception {
        if (this.actualInstance == null) {
            this.actualInstance = instance;
        }
        int hit = 0;
        int decoratorsSize = this.decorators.size();
        while (position.get().intValue() < decoratorsSize) {
            ++hit;
            int currentPosition = position.get().intValue();
            Object decorator = this.decorators.get(position.get().getAndIncrement());
            Method decMethod = decorator.getClass().getMethod(method.getName(), method.getParameterTypes());
            boolean methodInInterface = this.checkForMethodInInterfaces(decorator.getClass(), method);
            if (decMethod == null || !methodInInterface) continue;
            if (!decMethod.isAccessible()) {
                this.bean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)decMethod, true);
            }
            try {
                Object object = decMethod.invoke(decorator, arguments);
                if (currentPosition == 0) {
                    position.remove();
                }
                return object;
            }
            catch (Throwable throwable) {
                try {
                    if (currentPosition == 0) {
                        position.remove();
                    }
                    throw throwable;
                }
                catch (SecurityException e) {
                    logger.log(Level.SEVERE, "ERROR_0011", WebBeansLoggerFacade.args(method.getName(), decorator.getClass().getName()));
                    throw new WebBeansException(e);
                }
                catch (NoSuchMethodException e) {
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof NoSuchMethodException) continue;
                    logger.log(Level.SEVERE, "ERROR_0012", WebBeansLoggerFacade.args(e.getTargetException(), method.getName(), decorator.getClass().getName()));
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new WebBeansException(e);
                }
                catch (IllegalAccessException e) {
                    logger.log(Level.SEVERE, "ERROR_0014", WebBeansLoggerFacade.args(method.getName(), decorator.getClass().getName()));
                    throw new WebBeansException(e);
                }
            }
        }
        if (hit == decoratorsSize) {
            position.remove();
        }
        if (!method.isAccessible()) {
            this.bean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)method, true);
        }
        Object result = null;
        if (!(this.bean instanceof EnterpriseBeanMarker)) {
            result = method.invoke(this.actualInstance, arguments);
        } else if (this.ejbContext != null) {
            Method ejbMethod = this.ejbContext.getMethod();
            if (method.getName().equals(ejbMethod.getName()) && method.getReturnType().equals(ejbMethod.getReturnType())) {
                result = this.ejbContext.proceed();
            } else {
                Object ejbInstance = this.ejbContext.getTarget();
                result = method.invoke(ejbInstance, arguments);
            }
        }
        return result;
    }

    private boolean checkForMethodInInterfaces(Class<?> class1, Method m) {
        Class<?>[] interfaces = class1.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                if (interfaces[i].getMethod(m.getName(), m.getParameterTypes()) == null) continue;
                return true;
            }
            catch (NoSuchMethodException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void setDecorators(List<Object> dec) {
        this.decorators = dec;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        String id = WebBeansUtil.isPassivationCapable(this.bean);
        if (id != null) {
            out.writeObject(id);
            out.writeObject(this.decorators);
        } else {
            out.writeObject("");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String id = (String)in.readObject();
        if (id.equals("")) {
            return;
        }
        this.bean = (OwbBean)WebBeansContext.currentInstance().getBeanManagerImpl().getPassivationCapableBean(id);
        this.decorators = (List)in.readObject();
    }
}

