/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleConfigurationConvertor {
    private final Logger logger;
    private final BundleContext context;
    private final ConfigurationAdmin configAdmin;
    private ServiceRegistration<ManagedService> configuratorRegistration;
    private static final String CONSOLE_PID = "osgi.console";
    private static final String TELNET_PID = "osgi.console.telnet";
    private static final String SSH_PID = "osgi.console.ssh";
    private static final String TELNET_PORT = "telnet.port";
    private static final String TELNET_HOST = "telnet.host";
    private static final String TELNET_ENABLED = "telnet.enabled";
    private static final String SSH_PORT = "ssh.port";
    private static final String SSH_HOST = "ssh.host";
    private static final String SSH_ENABLED = "ssh.enabled";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String ENABLED = "enabled";
    private static final String TELNET_SERVICE = "telnet";
    private static final String SSH_SERVICE = "ssh";
    private static final Object monitor = new Object();

    ConsoleConfigurationConvertor(BundleContext context, ConfigurationAdmin configAdmin) {
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.context = context;
            this.configAdmin = configAdmin;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            Hashtable<String, String> consoleProperties = new Hashtable<String, String>();
            ((Dictionary)consoleProperties).put("service.pid", CONSOLE_PID);
            Object object = monitor;
            synchronized (object) {
                this.configuratorRegistration = this.context.registerService(ManagedService.class, (Object)new ConsoleConfigurator(), consoleProperties);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void updateConfiguration(String pid, String host, String port, String enabled) {
        try {
            boolean isPortAvailable = pid.contains(TELNET_SERVICE) ? this.checkPortAvailability(port, enabled, TELNET_SERVICE) : this.checkPortAvailability(port, enabled, SSH_SERVICE);
            if (!isPortAvailable) {
                return;
            }
            try {
                Configuration configuration = this.configAdmin.getConfiguration(pid, null);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put(HOST, host);
                ((Dictionary)properties).put(PORT, port);
                ((Dictionary)properties).put(ENABLED, enabled);
                configuration.update(properties);
            }
            catch (IOException e) {
                String message = String.format("Unable to update configuration with pid '%s'", pid);
                this.logger.error(message, (Throwable)e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void stop() {
        try {
            this.deleteConfiguration(TELNET_PID);
            this.deleteConfiguration(SSH_PID);
            this.deleteConfiguration(CONSOLE_PID);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void deleteConfiguration(String pid) {
        try {
            try {
                Configuration configuration = this.configAdmin.getConfiguration(pid, null);
                configuration.delete();
            }
            catch (IOException e) {
                String message = String.format("Unable to delete configuration with pid: " + pid, new Object[0]);
                this.logger.error(message, (Throwable)e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkPortAvailability(String portStr, String enabled, String service) {
        try {
            if ("false".equalsIgnoreCase(enabled)) {
                return true;
            }
            int port = Integer.parseInt(portStr);
            ServerSocket socket = null;
            socket = new ServerSocket(port);
            if (socket == null) return true;
            try {
                socket.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
            catch (BindException e) {
                String message = "Port " + port + " already in use; " + service + " access to console will not be available";
                this.logger.error(message, (Throwable)e);
                if (socket == null) return false;
                try {
                    socket.close();
                    return false;
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (IOException iOException) {
                if (socket == null) return false;
                {
                    catch (Throwable throwable) {
                        if (socket == null) throw throwable;
                        try {
                            socket.close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
                try {
                    socket.close();
                    return false;
                }
                catch (IOException iOException3) {}
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Object access$0() {
        try {
            return monitor;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ ServiceRegistration access$1(ConsoleConfigurationConvertor arg0) {
        try {
            return arg0.configuratorRegistration;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$2(ConsoleConfigurationConvertor arg0, String arg1, String arg2, String arg3, String arg4) {
        try {
            arg0.updateConfiguration(arg1, arg2, arg3, arg4);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    class ConsoleConfigurator
    implements ManagedService {
        private Dictionary<String, String> properties;

        ConsoleConfigurator() {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updated(Dictionary props) throws ConfigurationException {
            try {
                if (props == null) {
                    return;
                }
                this.properties = props;
                this.properties.put("service.pid", ConsoleConfigurationConvertor.CONSOLE_PID);
                Object object = ConsoleConfigurationConvertor.access$0();
                synchronized (object) {
                    ConsoleConfigurationConvertor.access$1(ConsoleConfigurationConvertor.this).setProperties(this.properties);
                }
                String telnetHost = this.properties.get(ConsoleConfigurationConvertor.TELNET_HOST);
                String telnetPort = this.properties.get(ConsoleConfigurationConvertor.TELNET_PORT);
                String telnetEnabled = this.properties.get(ConsoleConfigurationConvertor.TELNET_ENABLED);
                ConsoleConfigurationConvertor.access$2(ConsoleConfigurationConvertor.this, ConsoleConfigurationConvertor.TELNET_PID, telnetHost, telnetPort, telnetEnabled);
                String sshHost = this.properties.get(ConsoleConfigurationConvertor.SSH_HOST);
                String sshPort = this.properties.get(ConsoleConfigurationConvertor.SSH_PORT);
                String sshEnabled = this.properties.get(ConsoleConfigurationConvertor.SSH_ENABLED);
                ConsoleConfigurationConvertor.access$2(ConsoleConfigurationConvertor.this, ConsoleConfigurationConvertor.SSH_PID, sshHost, sshPort, sshEnabled);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }
}

