/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.formatting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.shell.internal.formatting.AbstractInstallArtifactCommandFormatter;
import org.eclipse.virgo.shell.internal.formatting.PropertyFormatter;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public final class ConfigInstallArtifactCommandFormatter
extends AbstractInstallArtifactCommandFormatter<ManageableArtifact> {
    private final ConfigurationAdmin configurationAdmin;

    public ConfigInstallArtifactCommandFormatter(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public List<String> formatExamine(ManageableArtifact artifact) {
        Configuration configuration;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            configuration = this.configurationAdmin.getConfiguration(artifact.getName(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String factoryPid = configuration.getFactoryPid();
        String bundleLocation = configuration.getBundleLocation();
        lines.add(String.format("Factory pid:     %s", factoryPid == null ? "" : factoryPid));
        lines.add(String.format("Bundle Location: %s", bundleLocation == null ? "" : bundleLocation));
        lines.addAll(this.formatProperties(configuration));
        return lines;
    }

    private List<String> formatProperties(Configuration configuration) {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<String> propertyKeys = new ArrayList<String>();
        Dictionary properties = configuration.getProperties();
        if (properties != null) {
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                propertyKeys.add((String)keys.nextElement());
            }
            Collections.sort(propertyKeys);
            lines.add("");
            lines.add(String.format("Properties:", new Object[0]));
            for (String propertyKey : propertyKeys) {
                lines.add(String.format("    %s:", propertyKey));
                List<String> values = PropertyFormatter.formatPropertyValue(properties.get(propertyKey), 80);
                for (String value : values) {
                    lines.add(String.format("        %s", value));
                }
            }
        }
        return lines;
    }
}

