/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.commands;

import java.util.Arrays;
import java.util.List;
import javax.management.InstanceNotFoundException;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.shell.Command;
import org.eclipse.virgo.shell.internal.commands.AbstractInstallArtifactBasedCommands;
import org.eclipse.virgo.shell.internal.formatting.ConfigInstallArtifactCommandFormatter;
import org.osgi.framework.Version;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(value="config")
final class ConfigCommands
extends AbstractInstallArtifactBasedCommands<ManageableArtifact> {
    private static final String UNABLE_TO_EXAMINE_CONFIGURATION_IN_NON_ACTIVE_STATE = String.format("Unable to examine configuration in non-active state", new Object[0]);
    private static final String EMPTY_VERSION_STRING = Version.emptyVersion.toString();
    private static final String GLOBAL_REGION_NAME = "global";
    private static final String TYPE = "configuration";
    private static final String STATE_ACTIVE = "ACTIVE";

    public ConfigCommands(RuntimeArtifactModelObjectNameCreator objectNameCreator, ConfigurationAdmin configurationAdmin, RegionDigraph regionDigraph) {
        super(TYPE, objectNameCreator, new ConfigInstallArtifactCommandFormatter(configurationAdmin), ManageableArtifact.class, regionDigraph);
    }

    @Command(value="examine")
    public List<String> examine(String name) {
        return this.examine(name, EMPTY_VERSION_STRING, GLOBAL_REGION_NAME);
    }

    @Command(value="examine")
    public List<String> examine(String name, String version) {
        return this.examine(name, version, GLOBAL_REGION_NAME);
    }

    @Override
    public List<String> examine(String name, String versionString, String regionName) {
        Object artifact;
        try {
            artifact = this.getArtifactRetriever().getArtifact(name, ConfigCommands.convertToVersion(versionString), this.convertToRegion(regionName));
        }
        catch (IllegalArgumentException iae) {
            return Arrays.asList(iae.getMessage());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return this.getDoesNotExistMessage(TYPE, name, versionString, regionName);
        }
        if (STATE_ACTIVE.equals(artifact.getState())) {
            return super.examine(name, versionString, regionName);
        }
        return Arrays.asList(UNABLE_TO_EXAMINE_CONFIGURATION_IN_NON_ACTIVE_STATE);
    }

    @Command(value="start")
    public List<String> start(String name) {
        return this.start(name, EMPTY_VERSION_STRING, GLOBAL_REGION_NAME);
    }

    @Command(value="start")
    public List<String> start(String name, String version) {
        return this.start(name, version, GLOBAL_REGION_NAME);
    }

    @Command(value="stop")
    public List<String> stop(String name) {
        return this.stop(name, EMPTY_VERSION_STRING, GLOBAL_REGION_NAME);
    }

    @Command(value="stop")
    public List<String> stop(String name, String version) {
        return this.stop(name, version, GLOBAL_REGION_NAME);
    }

    @Command(value="refresh")
    public List<String> refresh(String name) {
        return this.refresh(name, EMPTY_VERSION_STRING, GLOBAL_REGION_NAME);
    }

    @Command(value="refresh")
    public List<String> refresh(String name, String version) {
        return this.refresh(name, version, GLOBAL_REGION_NAME);
    }

    @Command(value="uninstall")
    public List<String> uninstall(String name) {
        return this.uninstall(name, EMPTY_VERSION_STRING, GLOBAL_REGION_NAME);
    }

    @Command(value="uninstall")
    public List<String> uninstall(String name, String version) {
        return this.uninstall(name, version, GLOBAL_REGION_NAME);
    }
}

