/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.telnet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.console.common.ConsoleInputStream;
import org.eclipse.equinox.console.common.ConsoleOutputStream;
import org.eclipse.equinox.console.common.KEYS;
import org.eclipse.equinox.console.common.Scanner;
import org.eclipse.equinox.console.common.terminal.TerminalTypeMappings;
import org.eclipse.equinox.console.telnet.Callback;

public class TelnetInputScanner
extends Scanner {
    private boolean isCommand = false;
    private boolean isReadingTtype = false;
    private boolean shouldFinish = false;
    private boolean tTypeNegotiationStarted = false;
    private int lastRead = -1;
    private ArrayList<Integer> currentTerminalType = new ArrayList();
    private ArrayList<Integer> lastTerminalType = null;
    private Set<String> supportedTerminalTypes = new HashSet<String>();
    private Callback callback;
    private static final int SE = 240;
    private static final int EC = 247;
    private static final int EL = 248;
    private static final int SB = 250;
    private static final int WILL = 251;
    private static final int WILL_NOT = 252;
    private static final int DO = 253;
    private static final int DO_NOT = 254;
    private static final int TTYPE = 24;
    private static final int SEND = 1;
    private static final int IAC = 255;
    private static final int IS = 0;
    private boolean isNegotiation;
    private boolean isWill;
    private byte[] tTypeRequest = new byte[]{-1, -6, 24, 1, -1, -16};

    public TelnetInputScanner(ConsoleInputStream toShell, ConsoleOutputStream toTelnet, Callback callback) {
        super(toShell, toTelnet);
        this.initializeSupportedTerminalTypes();
        TerminalTypeMappings currentMapping = (TerminalTypeMappings)this.supportedEscapeSequences.get(DEFAULT_TTYPE);
        this.currentEscapesToKey = currentMapping.getEscapesToKey();
        this.escapes = currentMapping.getEscapes();
        this.setBackspace(currentMapping.getBackspace());
        this.setDel(currentMapping.getDel());
        this.callback = callback;
    }

    private void initializeSupportedTerminalTypes() {
        this.supportedTerminalTypes.add("ANSI");
        this.supportedTerminalTypes.add("VT100");
        this.supportedTerminalTypes.add("VT220");
        this.supportedTerminalTypes.add("VT320");
        this.supportedTerminalTypes.add("XTERM");
        this.supportedTerminalTypes.add("SCO");
    }

    public void scan(int b) throws IOException {
        b &= 0xFF;
        if (this.isEsc) {
            this.scanEsc(b);
        } else if (this.isCommand) {
            this.scanCommand(b);
        } else if (b == 255) {
            this.startCommand();
        } else {
            switch (b) {
                case 27: {
                    this.startEsc();
                    this.toShell.add(new byte[]{(byte)b});
                    break;
                }
                default: {
                    if (b >= 32 && b < 127) {
                        this.echo((byte)b);
                        this.flush();
                    }
                    this.toShell.add(new byte[]{(byte)b});
                }
            }
        }
        this.lastRead = b;
    }

    private void scanCommand(int b) throws IOException {
        if (this.isNegotiation) {
            this.scanNegotiation(b);
        } else if (this.isWill) {
            this.isWill = false;
            this.isCommand = false;
            if (b == 24 && !this.tTypeNegotiationStarted) {
                this.sendRequest();
            }
        } else {
            switch (b) {
                case 251: {
                    this.isWill = true;
                    break;
                }
                case 252: {
                    break;
                }
                case 253: {
                    break;
                }
                case 254: {
                    break;
                }
                case 250: {
                    this.isNegotiation = true;
                    break;
                }
                case 247: {
                    this.eraseChar();
                    this.isCommand = false;
                    break;
                }
                default: {
                    this.isCommand = false;
                }
            }
        }
    }

    private void scanNegotiation(int b) {
        if (this.lastRead == 250 && b == 24) {
            this.isReadingTtype = true;
        } else if (b != 0 && b != 255) {
            if (b == 240) {
                this.isNegotiation = false;
                this.isCommand = false;
                if (this.isReadingTtype) {
                    this.isReadingTtype = false;
                    if (this.shouldFinish) {
                        this.setCurrentTerminalType();
                        this.shouldFinish = false;
                        return;
                    }
                    boolean isMatch = this.isTerminalTypeSupported();
                    boolean isLast = this.isLast();
                    if (isMatch) {
                        this.setCurrentTerminalType();
                        return;
                    }
                    this.lastTerminalType = this.currentTerminalType;
                    this.currentTerminalType = new ArrayList();
                    if (isLast && !isMatch) {
                        this.shouldFinish = true;
                        this.sendRequest();
                    } else if (!isLast && !isMatch) {
                        this.sendRequest();
                    }
                }
            } else if (this.isReadingTtype) {
                this.currentTerminalType.add(b);
            }
        }
    }

    private boolean isTerminalTypeSupported() {
        byte[] tmp = new byte[this.currentTerminalType.size()];
        int idx = 0;
        for (Integer i : this.currentTerminalType) {
            tmp[idx] = i.byteValue();
            ++idx;
        }
        String tType = new String(tmp);
        for (String terminal : this.supportedTerminalTypes) {
            if (!tType.toUpperCase().contains(terminal)) continue;
            return true;
        }
        return false;
    }

    private boolean isLast() {
        return this.currentTerminalType.equals(this.lastTerminalType);
    }

    private void setCurrentTerminalType() {
        byte[] tmp = new byte[this.currentTerminalType.size()];
        int idx = 0;
        for (Integer i : this.currentTerminalType) {
            tmp[idx] = i.byteValue();
            ++idx;
        }
        String tType = new String(tmp);
        String term = null;
        for (String terminal : this.supportedTerminalTypes) {
            if (!tType.toUpperCase().contains(terminal)) continue;
            term = terminal;
        }
        TerminalTypeMappings currentMapping = (TerminalTypeMappings)this.supportedEscapeSequences.get(term);
        if (currentMapping == null) {
            currentMapping = (TerminalTypeMappings)this.supportedEscapeSequences.get(DEFAULT_TTYPE);
        }
        this.currentEscapesToKey = currentMapping.getEscapesToKey();
        this.escapes = currentMapping.getEscapes();
        this.setBackspace(currentMapping.getBackspace());
        this.setDel(currentMapping.getDel());
        if (this.callback != null) {
            this.callback.finished();
        }
    }

    private void sendRequest() {
        try {
            this.toTelnet.write(this.tTypeRequest);
            this.toTelnet.flush();
            if (!this.tTypeNegotiationStarted) {
                this.tTypeNegotiationStarted = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startCommand() {
        this.isCommand = true;
        this.isNegotiation = false;
        this.isWill = false;
    }

    private void eraseChar() throws IOException {
        this.toShell.add(new byte[]{8});
    }

    protected void scanEsc(int b) throws IOException {
        this.esc = String.valueOf(this.esc) + (char)b;
        this.toShell.add(new byte[]{(byte)b});
        KEYS key = this.checkEscape(this.esc);
        if (key == KEYS.UNFINISHED) {
            return;
        }
        if (key == KEYS.UNKNOWN) {
            this.isEsc = false;
            this.scan(b);
            return;
        }
        this.isEsc = false;
    }
}

