/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.formatting;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class PropertyFormatter {
    public static List<String> formatPropertyValue(Object value, int maxLineLength) {
        String[] strings = value.getClass().isArray() ? PropertyFormatter.arrayToStrings(value) : new String[]{value.toString()};
        int lineLength = 0;
        ArrayList<String> formatted = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < strings.length) {
            String item = i < strings.length - 1 ? String.valueOf(strings[i]) + ", " : strings[i];
            if (!PropertyFormatter.isSufficientRoomForNextItem(item, lineLength, maxLineLength) && PropertyFormatter.addEntryIfNecessary(builder, formatted)) {
                builder = new StringBuilder();
                lineLength = 0;
            }
            builder.append(item);
            lineLength += item.length();
            ++i;
        }
        PropertyFormatter.addEntryIfNecessary(builder, formatted);
        return formatted;
    }

    private static boolean addEntryIfNecessary(StringBuilder builder, List<String> entries) {
        String string = builder.toString();
        if (!string.isEmpty()) {
            entries.add(string);
            return true;
        }
        return false;
    }

    private static boolean isSufficientRoomForNextItem(String item, int currentLineLength, int maxLineLength) {
        return currentLineLength + item.length() <= maxLineLength;
    }

    private static String[] arrayToStrings(Object array) {
        int length = Array.getLength(array);
        String[] strings = new String[length];
        int i = 0;
        while (i < length) {
            Object object = Array.get(array, i);
            strings[i] = object == null ? "null" : object.toString();
            ++i;
        }
        return strings;
    }
}

