/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal.uri;

import java.net.URI;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployUriNormaliser;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Version;

final class RepositoryDeployUriNormaliser
implements DeployUriNormaliser {
    private static final String SCHEME_REPOSITORY = "repository";
    private static final int COMPONENTS_MINIMUM = 2;
    private static final int COMPONENTS_MAXIMUM = 3;
    private final Repository repository;
    private final EventLogger eventLogger;

    RepositoryDeployUriNormaliser(@NonNull Repository repository, EventLogger eventLogger) {
        this.repository = repository;
        this.eventLogger = eventLogger;
    }

    public URI normalise(URI uri) throws DeploymentException {
        if (SCHEME_REPOSITORY.equals(uri.getScheme())) {
            return this.normaliseRepositoryUri(uri);
        }
        return null;
    }

    private URI normaliseRepositoryUri(URI uri) throws DeploymentException {
        String[] tnv = this.extractTypeNameAndVersion(uri);
        URI normalisedUri = null;
        if (tnv.length >= 2 && tnv.length <= 3) {
            ArtifactDescriptor artifactDescriptor;
            String versionString = null;
            if (tnv.length == 3) {
                versionString = tnv[2];
            }
            if ((artifactDescriptor = this.lookupArtifactDescriptor(tnv[0], tnv[1], versionString, uri)) != null) {
                normalisedUri = artifactDescriptor.getUri();
            }
        } else {
            this.eventLogger.log((LogEvent)DeployerLogEvents.REPOSITORY_DEPLOYMENT_URI_MALFORMED, new Object[]{uri});
            throw new DeploymentException("The URI '" + uri + "' is malformed");
        }
        return normalisedUri;
    }

    private String[] extractTypeNameAndVersion(URI uri) {
        String tnv = uri.getSchemeSpecificPart();
        String[] tnvComponents = tnv.split("/");
        return tnvComponents;
    }

    private ArtifactDescriptor lookupArtifactDescriptor(String type, String name, String versionString, URI uri) throws DeploymentException {
        try {
            VersionRange versionRange;
            if (versionString == null) {
                versionRange = VersionRange.NATURAL_NUMBER_RANGE;
            } else {
                Version version = new Version(versionString);
                versionRange = VersionRange.createExactRange((Version)version);
            }
            RepositoryAwareArtifactDescriptor artifactDescriptor = this.repository.get(type, name, versionRange);
            if (artifactDescriptor == null) {
                this.eventLogger.log((LogEvent)DeployerLogEvents.ARTIFACT_NOT_FOUND, new Object[]{type, name, versionRange, this.repository.getName()});
                throw new DeploymentException("The URI '" + uri + "' references a non-existent artifact");
            }
            return artifactDescriptor;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.REPOSITORY_DEPLOYMENT_INVALID_VERSION, new Object[]{versionString, uri});
            throw new DeploymentException("The version '" + versionString + "' is invalid");
        }
    }
}

