/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.util.Map;
import org.eclipse.virgo.util.osgi.manifest.BundleSymbolicName;

final class DescopingBundleSymbolicName
implements BundleSymbolicName {
    public static final String SCOPE_SEPARATOR = "-";
    private final BundleSymbolicName wrappedBundleSymbolicName;
    private final String moduleScope;

    DescopingBundleSymbolicName(BundleSymbolicName bundleSymbolicName, String moduleScope) {
        this.wrappedBundleSymbolicName = bundleSymbolicName;
        this.moduleScope = moduleScope;
    }

    public BundleSymbolicName.FragmentAttachment getFragmentAttachment() {
        return this.wrappedBundleSymbolicName.getFragmentAttachment();
    }

    public String getSymbolicName() {
        return this.getUnscopedSymbolicName();
    }

    private String getUnscopedSymbolicName() {
        String symbolicName = null;
        if (this.wrappedBundleSymbolicName != null) {
            String scopeName;
            symbolicName = this.wrappedBundleSymbolicName.getSymbolicName();
            if (this.moduleScope != null && symbolicName.startsWith(scopeName = String.valueOf(this.moduleScope) + SCOPE_SEPARATOR)) {
                symbolicName = symbolicName.substring(scopeName.length());
            }
        }
        return symbolicName;
    }

    public boolean isSingleton() {
        return this.wrappedBundleSymbolicName.isSingleton();
    }

    public void setFragmentAttachment(BundleSymbolicName.FragmentAttachment fragmentAttachment) {
        this.wrappedBundleSymbolicName.setFragmentAttachment(fragmentAttachment);
    }

    public void setSingleton(boolean singleton) {
        this.wrappedBundleSymbolicName.setSingleton(singleton);
    }

    public void setSymbolicName(String symbolicName) {
        this.wrappedBundleSymbolicName.setSymbolicName(symbolicName);
    }

    public Map<String, String> getAttributes() {
        return this.wrappedBundleSymbolicName.getAttributes();
    }

    public Map<String, String> getDirectives() {
        return this.wrappedBundleSymbolicName.getDirectives();
    }

    public void resetFromParseString(String string) {
        this.wrappedBundleSymbolicName.resetFromParseString(string);
    }

    public String toParseString() {
        return this.wrappedBundleSymbolicName.toParseString();
    }
}

