/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.shell.Command;
import org.eclipse.virgo.shell.internal.CommandDescriptor;
import org.eclipse.virgo.shell.internal.CommandResolver;
import org.osgi.framework.ServiceReference;

final class AnnotationBasedCommandResolver
implements CommandResolver {
    AnnotationBasedCommandResolver() {
    }

    @Override
    public List<CommandDescriptor> resolveCommands(ServiceReference<?> serviceReference, Object object) {
        ArrayList<CommandDescriptor> commandDescriptors = new ArrayList<CommandDescriptor>();
        Class<?> clazz = object.getClass();
        String commandName = this.getCommandName(clazz);
        if (commandName != null) {
            while (clazz != null) {
                commandDescriptors.addAll(this.resolveCommands(clazz, object, commandName));
                clazz = clazz.getSuperclass();
            }
        }
        return commandDescriptors;
    }

    private List<CommandDescriptor> resolveCommands(Class<?> clazz, Object object, String commandName) {
        ArrayList<CommandDescriptor> commandDescriptors = new ArrayList<CommandDescriptor>();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String subCommandName = this.getCommandName(method);
            if (subCommandName != null) {
                commandDescriptors.add(new CommandDescriptor(commandName, subCommandName, method, object));
            }
            ++n2;
        }
        return commandDescriptors;
    }

    private String getCommandName(AnnotatedElement annotatedElement) {
        Command command = annotatedElement.getAnnotation(Command.class);
        if (command == null) {
            return null;
        }
        return command.value();
    }
}

