/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSFactory;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStore;
import org.eclipse.virgo.kernel.install.artifact.internal.FileMovingArtifactStore;
import org.eclipse.virgo.kernel.install.artifact.internal.GenerationalArtifactStore;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.io.JarUtils;
import org.eclipse.virgo.util.io.PathReference;

final class StandardArtifactStorage
implements ArtifactStorage {
    private static final String DEPLOYER_UNPACK_BUNDLES_TRUE = "true";
    private static final List<String> CONSTANT_PATH_EXTENSIONS;
    private static final List<String> ALWAYS_UNPACKED_EXTENSIONS;
    private static final List<String> CONFIGURABLY_UNPACKED_EXTENSIONS;
    private final PathReference sourcePathReference;
    private final ArtifactFSFactory artifactFSFactory;
    private final EventLogger eventLogger;
    private final boolean unpackBundles;
    private final ArtifactStore pathGenerator;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        Factory factory = new Factory("StandardArtifactStorage.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStorage"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "synchronize", "org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStorage", "", "", "", "void"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "synchronize", "org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStorage", "java.net.URI:", "sourceUri:", "", "void"), 79);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rollBack", "org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStorage", "", "", "", "void"), 85);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStorage", "", "", "", "void"), 90);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "synchronize", "org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStorage", "org.eclipse.virgo.util.io.PathReference:", "normalizedSourcePathReference:", "", "void"), 95);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "needsUnpacking", "org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStorage", "org.eclipse.virgo.util.io.PathReference:", "pathReference:", "", "boolean"), 112);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStorage");
        CONSTANT_PATH_EXTENSIONS = Arrays.asList("par", "zip");
        ALWAYS_UNPACKED_EXTENSIONS = Arrays.asList("par", "zip");
        CONFIGURABLY_UNPACKED_EXTENSIONS = Arrays.asList("jar", "war");
    }

    public StandardArtifactStorage(PathReference sourcePathReference, PathReference baseStagingPathReference, ArtifactFSFactory artifactFSFactory, EventLogger eventLogger, String unpackBundlesOption) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.sourcePathReference = sourcePathReference;
            this.artifactFSFactory = artifactFSFactory;
            this.eventLogger = eventLogger;
            this.unpackBundles = unpackBundlesOption == null || DEPLOYER_UNPACK_BUNDLES_TRUE.equalsIgnoreCase(unpackBundlesOption);
            this.pathGenerator = CONSTANT_PATH_EXTENSIONS.contains(StandardArtifactStorage.getFileExtension(sourcePathReference)) ? new FileMovingArtifactStore(baseStagingPathReference) : new GenerationalArtifactStore(baseStagingPathReference);
            PathReference currentPathReference = this.pathGenerator.getCurrentPath();
            currentPathReference.delete(true);
            this.synchronize(this.sourcePathReference);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void synchronize() {
        try {
            try {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                this.pathGenerator.save();
                this.synchronize(this.sourcePathReference);
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public ArtifactFS getArtifactFS() {
        try {
            return this.artifactFSFactory.create(this.pathGenerator.getCurrentPath().toFile());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void synchronize(URI sourceUri) {
        try {
            try {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                this.pathGenerator.save();
                this.synchronize(new PathReference(sourceUri));
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void rollBack() {
        try {
            try {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                this.pathGenerator.restore();
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void delete() {
        try {
            try {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                PathReference currentPathReference = this.pathGenerator.getCurrentPath();
                currentPathReference.delete(true);
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void synchronize(PathReference normalizedSourcePathReference) {
        try {
            try {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                PathReference currentPathReference = this.pathGenerator.getCurrentPath();
                if (normalizedSourcePathReference != null && !normalizedSourcePathReference.isDirectory() && this.needsUnpacking(normalizedSourcePathReference)) {
                    try {
                        JarUtils.unpackTo((PathReference)normalizedSourcePathReference, (PathReference)currentPathReference);
                    }
                    catch (IOException e) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.JAR_UNPACK_ERROR, (Throwable)e, new Object[]{normalizedSourcePathReference});
                        throw new RuntimeException(String.format("Exception unpacking '%s'", normalizedSourcePathReference), e);
                    }
                } else if (normalizedSourcePathReference != null) {
                    normalizedSourcePathReference.copy(currentPathReference, true);
                } else {
                    currentPathReference.createDirectory();
                }
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean needsUnpacking(PathReference pathReference) {
        try {
            try {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                String fileExtension = StandardArtifactStorage.getFileExtension(pathReference);
                boolean bl = fileExtension == null ? false : ALWAYS_UNPACKED_EXTENSIONS.contains(fileExtension) || this.unpackBundles && CONFIGURABLY_UNPACKED_EXTENSIONS.contains(fileExtension);
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return bl;
            }
            catch (Throwable throwable) {
                StandardArtifactStorage.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String getFileExtension(PathReference pathReference) {
        try {
            if (pathReference == null) {
                return null;
            }
            String name = pathReference.getName();
            String fileName = name.toLowerCase(Locale.ENGLISH);
            int dotLocation = fileName.lastIndexOf(46);
            if (dotLocation == -1) {
                return null;
            }
            return fileName.substring(dotLocation + 1);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

