/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.resource.ResourceException;
import javax.resource.spi.DissociatableManagedConnection;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;

public class AutoConnectionTracker
implements ConnectionTracker {
    private final ConcurrentMap<ManagedConnectionInfo, ProxyPhantomReference> references = new ConcurrentHashMap<ManagedConnectionInfo, ProxyPhantomReference>();
    private final ReferenceQueue referenceQueue = new ReferenceQueue();

    public void setEnvironment(ConnectionInfo connectionInfo, String key) {
        ProxyPhantomReference reference = (ProxyPhantomReference)this.referenceQueue.poll();
        while (reference != null) {
            reference.clear();
            this.references.remove(reference.managedConnectionInfo);
            ConnectionInfo released = new ConnectionInfo(reference.managedConnectionInfo);
            reference.interceptor.returnConnection(released, ConnectionReturnAction.DESTROY);
            reference = (ProxyPhantomReference)this.referenceQueue.poll();
        }
    }

    public void handleObtained(ConnectionTrackingInterceptor interceptor, ConnectionInfo connectionInfo, boolean reassociate) throws ResourceException {
        if (!reassociate) {
            this.proxyConnection(interceptor, connectionInfo);
        }
    }

    public void handleReleased(ConnectionTrackingInterceptor interceptor, ConnectionInfo connectionInfo, ConnectionReturnAction action) {
        PhantomReference phantomReference = (PhantomReference)this.references.remove(connectionInfo.getManagedConnectionInfo());
        if (phantomReference != null) {
            phantomReference.clear();
        }
    }

    private void proxyConnection(ConnectionTrackingInterceptor interceptor, ConnectionInfo connectionInfo) throws ResourceException {
        if (connectionInfo.getConnectionProxy() != null) {
            return;
        }
        if (connectionInfo.getManagedConnectionInfo().getManagedConnection() instanceof DissociatableManagedConnection) {
            return;
        }
        try {
            Object handle = connectionInfo.getConnectionHandle();
            ConnectionInvocationHandler invocationHandler = new ConnectionInvocationHandler(handle);
            Object proxy = Proxy.newProxyInstance(handle.getClass().getClassLoader(), handle.getClass().getInterfaces(), (InvocationHandler)invocationHandler);
            connectionInfo.setConnectionProxy(proxy);
            ProxyPhantomReference reference = new ProxyPhantomReference(interceptor, connectionInfo.getManagedConnectionInfo(), invocationHandler, this.referenceQueue);
            this.references.put(connectionInfo.getManagedConnectionInfo(), reference);
        }
        catch (Throwable e) {
            throw new ResourceException("Unable to construct connection proxy", e);
        }
    }

    public static class ConnectionInvocationHandler
    implements InvocationHandler {
        private final Object handle;

        public ConnectionInvocationHandler(Object handle) {
            this.handle = handle;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method.getName().equals("finalize")) {
                    return null;
                }
                if (method.getName().equals("clone")) {
                    throw new CloneNotSupportedException();
                }
            }
            try {
                Object value = method.invoke(this.handle, args);
                return value;
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (t != null) {
                    throw t;
                }
                throw ite;
            }
        }
    }

    private static class ProxyPhantomReference
    extends PhantomReference<ConnectionInvocationHandler> {
        private ConnectionTrackingInterceptor interceptor;
        private ManagedConnectionInfo managedConnectionInfo;

        public ProxyPhantomReference(ConnectionTrackingInterceptor interceptor, ManagedConnectionInfo managedConnectionInfo, ConnectionInvocationHandler handler, ReferenceQueue referenceQueue) {
            super(handler, referenceQueue);
            this.interceptor = interceptor;
            this.managedConnectionInfo = managedConnectionInfo;
        }
    }
}

