/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;

public abstract class AbstractLiteralExpressionFactory
extends ExpressionFactory {
    protected AbstractLiteralExpressionFactory(String id) {
        super(id, new String[0]);
    }

    protected abstract AbstractExpression buildExpression(AbstractExpression var1, WordParser var2, String var3, AbstractExpression var4, boolean var5);

    protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        switch (wordParser.getWordType()) {
            case NUMERIC_LITERAL: {
                expression = new NumericLiteral(parent, word);
                expression.parse(wordParser, tolerant);
                return expression;
            }
            case STRING_LITERAL: {
                expression = new StringLiteral(parent, word);
                expression.parse(wordParser, tolerant);
                return expression;
            }
            case INPUT_PARAMETER: {
                expression = new InputParameter(parent, word);
                expression.parse(wordParser, tolerant);
                return expression;
            }
        }
        char character = word.charAt(0);
        if (word.indexOf(46) > -1) {
            expression = expression != null && character == '.' ? new StateFieldPathExpression(parent, expression, word) : new StateFieldPathExpression(parent, word);
            expression.parse(wordParser, tolerant);
            return expression;
        }
        String fallBackExpressionFactoryId = this.getFallBackExpressionFactoryId();
        if (fallBackExpressionFactoryId != null) {
            ExpressionFactory factory = this.getExpressionRegistry().getExpressionFactory(fallBackExpressionFactoryId);
            expression = factory.buildExpression(parent, wordParser, word, null, expression, tolerant);
            this.setFallBackExpressionFactory(null);
            if (expression != null) {
                return expression;
            }
        }
        return this.buildExpression(parent, wordParser, word, expression, tolerant);
    }
}

