/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.javax.persistence.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import org.eclipse.persistence.javax.persistence.osgi.OSGiProviderResolver;
import org.eclipse.virgo.web.enterprise.javax.persistence.extension.DefaultPersistenceProviderResolver;
import org.osgi.framework.BundleContext;

public class CompositePersistenceProviderResolver
implements PersistenceProviderResolver {
    private PersistenceProviderResolver osgiPersistenceProviderResolver;
    private PersistenceProviderResolver defaultPersistenceProviderResolver;
    private static final Logger logger = Logger.getLogger("com.sap.core.services.accessor.javax.persistence.extension.CompositePersistenceProviderResolver");

    public CompositePersistenceProviderResolver(BundleContext context) {
        this.osgiPersistenceProviderResolver = new OSGiProviderResolver(context);
        this.defaultPersistenceProviderResolver = new DefaultPersistenceProviderResolver();
        this.log(Level.FINEST, "Persistence providers created");
    }

    public List<PersistenceProvider> getPersistenceProviders() {
        List defaultPersistenceProviders = this.defaultPersistenceProviderResolver.getPersistenceProviders();
        ArrayList<PersistenceProvider> persistenceProviders = new ArrayList<PersistenceProvider>();
        if (this.osgiPersistenceProviderResolver != null) {
            List osgiPersistenceProviders = this.osgiPersistenceProviderResolver.getPersistenceProviders();
            for (PersistenceProvider provider : osgiPersistenceProviders) {
                persistenceProviders.add(provider);
            }
        } else {
            this.log(Level.FINEST, "Osgi Persistence Provider Resolver does not exist, getting persistence providers only from the default resolver");
        }
        for (PersistenceProvider provider : defaultPersistenceProviders) {
            persistenceProviders.add(provider);
        }
        this.log(Level.FINEST, "Found " + persistenceProviders.size() + " PersistenceProviders");
        return persistenceProviders;
    }

    public void clearCachedProviders() {
        this.osgiPersistenceProviderResolver.clearCachedProviders();
        this.defaultPersistenceProviderResolver.clearCachedProviders();
        this.log(Level.FINEST, "Cleared providers cache");
    }

    public void removeOsgiProviderResolver() {
        this.osgiPersistenceProviderResolver = null;
        this.log(Level.FINEST, "Removed OSGi Persistence Provider Resolver");
    }

    private void log(Level level, String message) {
        if (logger.isLoggable(level)) {
            logger.log(level, message);
        }
    }
}

