/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class XMLRecord
extends AbstractRecord {
    protected XMLMarshaller marshaller;
    protected XMLUnmarshaller unmarshaller;
    private DocumentPreservationPolicy docPresPolicy;
    private Object owningObject;
    protected Object currentObject;
    private XPathQName leafElementType;
    protected NamespaceResolver namespaceResolver;
    protected AbstractSession session;
    private boolean isXOPPackage;
    protected boolean namespaceAware = true;
    protected boolean hasCustomNamespaceMapper;
    protected boolean equalNamespaceResolvers = false;
    public static final Nil NIL = new Nil();

    public XMLRecord() {
        super(null, null);
    }

    @Override
    public Object get(String key) {
        return this.get(new XMLField(key));
    }

    @Override
    public Object put(String key, Object value) {
        return this.put(new XMLField(key), value);
    }

    public void attributeWithoutQName(String namespaceURI, String localName, String prefix, String value) {
        String qualifiedName = localName;
        if (prefix != null && prefix.length() > 0) {
            qualifiedName = String.valueOf(prefix) + this.getNamespaceSeparator() + qualifiedName;
        }
        this.attribute(namespaceURI, localName, qualifiedName, value);
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        XMLField xmlField = new XMLField(XMLConstants.ATTRIBUTE + qName);
        xmlField.setNamespaceResolver(this.getNamespaceResolver());
        xmlField.getLastXPathFragment().setNamespaceURI(namespaceURI);
        this.add(xmlField, value);
    }

    public void namespaceDeclaration(String prefix, String namespaceURI) {
        String existingPrefix = this.getNamespaceResolver().resolveNamespaceURI(namespaceURI);
        if (existingPrefix == null || existingPrefix != null && !existingPrefix.equals("") && !existingPrefix.equals(prefix)) {
            XMLField xmlField = new XMLField("@xmlns:" + prefix);
            xmlField.setNamespaceResolver(this.getNamespaceResolver());
            xmlField.getXPathFragment().setNamespaceURI("http://www.w3.org/2000/xmlns/");
            this.add(xmlField, namespaceURI);
        }
    }

    public abstract String getLocalName();

    public abstract String getNamespaceURI();

    @Override
    public abstract void clear();

    public abstract Document getDocument();

    @Override
    public boolean contains(Object value) {
        return this.values().contains(value);
    }

    public abstract Node getDOM();

    public abstract String transformToXML();

    protected XMLField convertToXMLField(DatabaseField databaseField) {
        try {
            return (XMLField)databaseField;
        }
        catch (ClassCastException classCastException) {
            return new XMLField(databaseField.getName());
        }
    }

    protected List<XMLField> convertToXMLField(List<DatabaseField> databaseFields) {
        ArrayList<XMLField> xmlFields = new ArrayList<XMLField>(databaseFields.size());
        for (DatabaseField next : databaseFields) {
            try {
                xmlFields.add((XMLField)next);
            }
            catch (ClassCastException classCastException) {
                xmlFields.add(new XMLField(next.getName()));
            }
        }
        return xmlFields;
    }

    @Override
    public Object get(DatabaseField key) {
        return this.getIndicatingNoEntry(key);
    }

    @Override
    public Object getIndicatingNoEntry(String fieldName) {
        return this.getIndicatingNoEntry(new XMLField(fieldName));
    }

    public String resolveNamespacePrefix(String prefix) {
        return null;
    }

    public XMLMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(XMLMarshaller marshaller) {
        this.marshaller = marshaller;
        if (marshaller != null) {
            MediaType mediaType = marshaller.getMediaType();
            this.namespaceAware = marshaller.getNamespacePrefixMapper() != null ? true : mediaType == MediaType.APPLICATION_XML;
        }
    }

    public XMLUnmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(XMLUnmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void setDocPresPolicy(DocumentPreservationPolicy policy) {
        this.docPresPolicy = policy;
    }

    public DocumentPreservationPolicy getDocPresPolicy() {
        return this.docPresPolicy;
    }

    public Object getOwningObject() {
        return this.owningObject;
    }

    public void setOwningObject(Object obj) {
        this.owningObject = obj;
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public void setCurrentObject(Object obj) {
        this.currentObject = obj;
    }

    public XPathQName getLeafElementType() {
        return this.leafElementType;
    }

    public void setLeafElementType(XPathQName type) {
        this.leafElementType = type;
    }

    public void setLeafElementType(QName type) {
        if (type != null) {
            this.setLeafElementType(new XPathQName(type, this.isNamespaceAware()));
        }
    }

    public void setNamespaceResolver(NamespaceResolver nr) {
        this.namespaceResolver = nr;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setEqualNamespaceResolvers(boolean equalNRs) {
        this.equalNamespaceResolvers = equalNRs;
    }

    public boolean hasEqualNamespaceResolvers() {
        return this.equalNamespaceResolvers;
    }

    public boolean isXOPPackage() {
        return this.isXOPPackage;
    }

    public void setXOPPackage(boolean isXOPPackage) {
        this.isXOPPackage = isXOPPackage;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public char getNamespaceSeparator() {
        return ':';
    }

    public boolean hasCustomNamespaceMapper() {
        return this.hasCustomNamespaceMapper;
    }

    public void setCustomNamespaceMapper(boolean customNamespaceMapper) {
        this.hasCustomNamespaceMapper = customNamespaceMapper;
    }

    private static class Nil {
        private Nil() {
        }
    }
}

