/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.persistence.openejb.classloading.hook;

import java.io.File;
import java.io.FilenameFilter;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.virgo.web.enterprise.persistence.openejb.classloading.hook.ClasspathExtenderClassLoadingHookException;
import org.osgi.framework.BundleException;

public class AppLoaderClasspathExtenderClassLoadingHook
implements ClassLoadingHook,
HookConfigurator {
    File persistenceIntegrationJar = null;
    private static final String FILE_SCHEME = "file:";
    private static final String WEB_CONTEXTPATH_HEADER = "Web-ContextPath";
    private static final Logger logger = Logger.getLogger("com.sap.core.service.accessor.persistence.classloading.hook.AppLoaderClasspathExtenderClassLoadingHook");
    private static final String PERSISTENCE_INTEGRATION_JAR_PROP_NAME = "persistence.integration.jar.name";
    private static final String PERSISTENCE_INTEGRATION_JAR = System.getProperty("persistence.integration.jar.name");
    private static final String CONFIG_AREA = "osgi.configuration.area";
    private static final String LIB_DIR = "lib";
    private static final String PERSISTENCE_DIR = "persistence";

    public void addHooks(HookRegistry registry) {
        registry.addClassLoadingHook((ClassLoadingHook)this);
    }

    public boolean addClassPathEntry(ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        if (this.isAppBundle(sourcedata) && this.shouldAdd(cpEntries)) {
            ClasspathEntry persistenceIntegrationClasspathEntry = null;
            try {
                persistenceIntegrationClasspathEntry = this.determinePersistenceIntegrationPath(hostmanager, sourcedata, sourcedomain);
            }
            catch (ClasspathExtenderClassLoadingHookException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (persistenceIntegrationClasspathEntry != null) {
                cpEntries.add(persistenceIntegrationClasspathEntry);
                return true;
            }
        }
        return false;
    }

    boolean shouldAdd(ArrayList<ClasspathEntry> cpEntries) {
        for (ClasspathEntry cpEntry : cpEntries) {
            if (!cpEntry.getBundleFile().getBaseFile().getName().startsWith(PERSISTENCE_INTEGRATION_JAR)) continue;
            return false;
        }
        return true;
    }

    ClasspathEntry determinePersistenceIntegrationPath(ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) throws ClasspathExtenderClassLoadingHookException {
        ClasspathEntry cp;
        if (this.persistenceIntegrationJar == null) {
            this.findPersistenceIntegrationJar();
        }
        if ((cp = hostmanager.getExternalClassPath(this.persistenceIntegrationJar.getAbsolutePath(), sourcedata, sourcedomain)) == null) {
            throw new ClasspathExtenderClassLoadingHookException("Failed to create classpath entry for file [" + PERSISTENCE_INTEGRATION_JAR + "]");
        }
        return cp;
    }

    void findPersistenceIntegrationJar() throws ClasspathExtenderClassLoadingHookException {
        String configurationPath = System.getProperty(CONFIG_AREA);
        if (configurationPath == null) {
            throw new ClasspathExtenderClassLoadingHookException("Property [osgi.configuration.area] is missing");
        }
        File configurationFile = new File(this.normalize(configurationPath));
        File lib = new File(configurationFile.getParentFile(), LIB_DIR);
        if (!lib.exists()) {
            throw new ClasspathExtenderClassLoadingHookException("lib folder is missing");
        }
        File persistenceLibDir = new File(lib, PERSISTENCE_DIR);
        if (!persistenceLibDir.exists()) {
            throw new ClasspathExtenderClassLoadingHookException("lib/persistence folder is missing");
        }
        String[] libs = persistenceLibDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(PERSISTENCE_INTEGRATION_JAR);
            }
        });
        if (libs.length == 0) {
            throw new ClasspathExtenderClassLoadingHookException("No file with name starting with [" + PERSISTENCE_INTEGRATION_JAR + "] was found in lib/persistence folder");
        }
        if (libs.length > 1) {
            logger.log(Level.SEVERE, "Found " + libs.length + " files with name starting with [" + PERSISTENCE_INTEGRATION_JAR + "] was found in lib/persistence folder (one expected); choosing [" + libs[0] + "]");
        }
        this.persistenceIntegrationJar = new File(persistenceLibDir, libs[0]);
    }

    String normalize(String filePath) {
        if (filePath.startsWith(FILE_SCHEME)) {
            return filePath.substring(FILE_SCHEME.length());
        }
        return filePath;
    }

    boolean isAppBundle(BaseData sourcedata) {
        try {
            return sourcedata.getManifest().get(WEB_CONTEXTPATH_HEADER) != null;
        }
        catch (BundleException e) {
            logger.log(Level.SEVERE, "Error checking if bundle [" + sourcedata + "] is application.", e);
            return false;
        }
    }

    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain protectionDomain, BaseData sourcedata, String[] classpath) {
        return null;
    }

    public String findLibrary(BaseData arg0, String arg1) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader arg0, BaseData arg1) {
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager classpathManager) {
        return null;
    }
}

