/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.eclipse.gemini.management.framework.CustomBundleWiringStateMBean;
import org.eclipse.gemini.management.framework.internal.OSGiBundleCapability;
import org.eclipse.gemini.management.framework.internal.OSGiBundleRequirement;
import org.eclipse.gemini.management.framework.internal.OSGiBundleRevisionIdTracker;
import org.eclipse.gemini.management.framework.internal.OSGiBundleWire;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public final class OSGiBundleWiring {
    private final BundleWiring wiring;

    public OSGiBundleWiring(BundleWiring wiring) {
        this.wiring = wiring;
    }

    public CompositeData asCompositeData(String namespace) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        this.addCapabilityAndRequirementItems(items, namespace);
        this.addProvidedAndRequiredWireItems(items, namespace);
        try {
            return new CompositeDataSupport(CustomBundleWiringStateMBean.BUNDLE_WIRING_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle wiring open data", e);
        }
    }

    public CompositeData asCompositeData(String namespace, OSGiBundleRevisionIdTracker revisionTracker) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        int myRevisionId = revisionTracker.getRevisionId(this.wiring.getRevision());
        this.addCapabilityAndRequirementItems(items, namespace);
        this.addRevisionedProvidedAndRequiredWireItems(items, namespace, revisionTracker);
        items.put("BundleRevisionId", myRevisionId);
        try {
            return new CompositeDataSupport(CustomBundleWiringStateMBean.BUNDLE_REVISION_WIRING_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle revisions wiring open data", e);
        }
    }

    public CompositeData asCompositeData(String namespace, long bundleId, OSGiBundleRevisionIdTracker revisionTracker) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        int myRevisionId = revisionTracker.getRevisionId(this.wiring.getRevision());
        this.addCapabilityAndRequirementItems(items, namespace);
        this.addRevisionedProvidedAndRequiredWireItems(items, namespace, revisionTracker);
        items.put("BundleId", bundleId);
        items.put("BundleRevisionId", myRevisionId);
        try {
            return new CompositeDataSupport(CustomBundleWiringStateMBean.BUNDLE_REVISION_WIRING_CLOSURE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle revisions wiring closures open data", e);
        }
    }

    private void addCapabilityAndRequirementItems(Map<String, Object> items, String namespace) {
        List requirements = this.wiring.getRequirements(namespace);
        CompositeData[] requirementsCompositeDate = new CompositeData[requirements.size()];
        int i = 0;
        while (i < requirements.size()) {
            requirementsCompositeDate[i] = new OSGiBundleRequirement((BundleRequirement)requirements.get(i)).asCompositeData();
            ++i;
        }
        items.put("Requirements", requirementsCompositeDate);
        List capabilities = this.wiring.getCapabilities(namespace);
        CompositeData[] capabilitiesCompositeDate = new CompositeData[capabilities.size()];
        int i2 = 0;
        while (i2 < capabilities.size()) {
            capabilitiesCompositeDate[i2] = new OSGiBundleCapability((BundleCapability)capabilities.get(i2)).asCompositeData();
            ++i2;
        }
        items.put("Capabilities", capabilitiesCompositeDate);
    }

    private void addProvidedAndRequiredWireItems(Map<String, Object> items, String namespace) {
        List requiredWires = this.wiring.getRequiredWires(namespace);
        CompositeData[] requiredWiresCompositeDate = new CompositeData[requiredWires.size()];
        int i = 0;
        while (i < requiredWires.size()) {
            requiredWiresCompositeDate[i] = new OSGiBundleWire((BundleWire)requiredWires.get(i)).asCompositeData();
            ++i;
        }
        items.put("RequiredWires", requiredWiresCompositeDate);
        List providedWires = this.wiring.getProvidedWires(namespace);
        CompositeData[] providedWiresCompositeDate = new CompositeData[providedWires.size()];
        int i2 = 0;
        while (i2 < providedWires.size()) {
            providedWiresCompositeDate[i2] = new OSGiBundleWire((BundleWire)providedWires.get(i2)).asCompositeData();
            ++i2;
        }
        items.put("ProvidedWires", providedWiresCompositeDate);
    }

    private void addRevisionedProvidedAndRequiredWireItems(Map<String, Object> items, String namespace, OSGiBundleRevisionIdTracker revisionTracker) {
        List requiredWires = this.wiring.getRequiredWires(namespace);
        CompositeData[] requiredWiresCompositeDate = new CompositeData[requiredWires.size()];
        int i = 0;
        while (i < requiredWires.size()) {
            requiredWiresCompositeDate[i] = new OSGiBundleWire((BundleWire)requiredWires.get(i)).asCompositeData(revisionTracker);
            ++i;
        }
        items.put("RevisionRequiredWires", requiredWiresCompositeDate);
        List providedWires = this.wiring.getProvidedWires(namespace);
        CompositeData[] providedWiresCompositeDate = new CompositeData[providedWires.size()];
        int i2 = 0;
        while (i2 < providedWires.size()) {
            providedWiresCompositeDate[i2] = new OSGiBundleWire((BundleWire)providedWires.get(i2)).asCompositeData(revisionTracker);
            ++i2;
        }
        items.put("RevisionProvidedWires", providedWiresCompositeDate);
    }
}

