/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.event;

import java.security.AccessController;
import org.eclipse.equinox.internal.util.event.PrivilegedActionImpl;
import org.eclipse.equinox.internal.util.event.Queue;

public abstract class EventThread
implements Runnable {
    public Object bad;
    protected Queue queue;
    protected int state;
    protected long time = 0L;
    protected int counter = 1;
    protected Object element;
    protected String baseName;
    protected String name;
    protected Thread thread;
    protected ThreadGroup group;
    private static PrivilegedActionImpl privilegedAction = null;

    public EventThread(ThreadGroup group, String name, int size) {
        this.group = group;
        this.name = String.valueOf(name) + '0';
        this.makeThread(this.group, this.name);
        this.baseName = name;
        this.queue = new Queue(size);
        int priority = this.getThreadPriority();
        if (priority != 5) {
            this.thread.setPriority(priority);
        }
    }

    public EventThread(ThreadGroup group, String name, Queue queue) {
        this.group = group;
        this.name = String.valueOf(name) + '0';
        this.makeThread(this.group, this.name);
        this.baseName = name;
        this.queue = queue;
        int priority = this.getThreadPriority();
        if (priority != 5) {
            this.thread.setPriority(priority);
        }
    }

    protected EventThread(EventThread old) {
        this.group = old.thread.getThreadGroup();
        this.name = String.valueOf(old.baseName) + old.counter++;
        this.makeThread(this.group, this.name);
        this.baseName = old.baseName;
        this.counter = old.counter;
        this.queue = old.queue;
        int priority = this.getThreadPriority();
        if (priority != 5) {
            this.thread.setPriority(priority);
        }
    }

    public void start() {
        this.thread.start();
    }

    public void addEvent(Object event, boolean check) {
        try {
            this.queue.put(event);
        }
        catch (Throwable t) {
            this.print(t);
            return;
        }
        if ((this.state & 2) != 0) {
            this.queue.notify();
        } else if (check && this.checkTime()) {
            try {
                this.state |= 1;
                this.newEventDispatcher();
            }
            catch (Throwable t) {
                this.print(t);
                this.state &= 0xFE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Queue queue = this.queue;
        synchronized (queue) {
            this.queue.notifyAll();
        }
        while (true) {
            try {
                while (true) {
                    queue = this.queue;
                    synchronized (queue) {
                        if ((this.state & 1) != 0) {
                            return;
                        }
                        while ((this.element = this.queue.get()) == null) {
                            try {
                                this.state |= 2;
                                this.queue.wait();
                                if ((this.state & 1) != 0) {
                                    return;
                                }
                                this.state &= 0xFD;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    this.processEvent();
                }
            }
            catch (Throwable t) {
                this.print(t);
                try {
                    throw new Exception();
                }
                catch (Exception exception) {
                    continue;
                }
            }
            break;
        }
    }

    private void makeThread(ThreadGroup group, String name) {
        try {
            if (privilegedAction == null) {
                privilegedAction = new PrivilegedActionImpl();
            }
            privilegedAction.set(group, this, name);
            this.thread = (Thread)AccessController.doPrivileged(privilegedAction);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc.toString());
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public String getName() {
        return this.name;
    }

    public abstract int getThreadPriority();

    public abstract void processEvent();

    public abstract boolean checkTime();

    public abstract void newEventDispatcher();

    public abstract void print(Throwable var1);
}

