/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.ConfigurationBase;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.Factory;
import org.osgi.service.cm.Configuration;

class ConfigurationImpl
extends ConfigurationBase {
    private static final String CONFIGURATION_NEW = "_felix_.cm.newConfiguration";
    private final String factoryPID;
    private volatile CaseInsensitiveDictionary properties;
    private volatile boolean isDeleted;
    private volatile long lastModificationTime;
    private volatile long lastUpdatedTime;

    ConfigurationImpl(ConfigurationManager configurationManager, PersistenceManager persistenceManager, Dictionary properties) {
        super(configurationManager, persistenceManager, (String)properties.remove("service.pid"), (String)properties.remove("service.bundleLocation"));
        this.factoryPID = (String)properties.remove("service.factoryPid");
        this.isDeleted = false;
        this.lastUpdatedTime = -1L;
        this.configureFromPersistence(properties);
    }

    ConfigurationImpl(ConfigurationManager configurationManager, PersistenceManager persistenceManager, String pid, String factoryPid, String bundleLocation) throws IOException {
        super(configurationManager, persistenceManager, pid, bundleLocation);
        this.factoryPID = factoryPid;
        this.isDeleted = false;
        this.properties = null;
        this.lastModificationTime = System.currentTimeMillis();
        this.lastUpdatedTime = -1L;
        if (factoryPid == null) {
            Hashtable<String, Boolean> props = new Hashtable<String, Boolean>();
            this.setAutoProperties(props, true);
            ((Dictionary)props).put(CONFIGURATION_NEW, Boolean.TRUE);
            persistenceManager.store(pid, props);
        }
    }

    public void delete() throws IOException {
        this.isDeleted = true;
        this.getPersistenceManager().delete(this.getPid());
        this.getConfigurationManager().setDynamicBundleLocation(this.getPid(), null);
        this.getConfigurationManager().deleted(this);
    }

    public String getPid() {
        return this.getBaseId();
    }

    public String getFactoryPid() {
        return this.factoryPID;
    }

    public Dictionary getProperties(boolean deepCopy) {
        if (this.properties == null) {
            return null;
        }
        CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(this.properties, deepCopy);
        this.setAutoProperties(props, false);
        return props;
    }

    public void update() throws IOException {
        PersistenceManager localPersistenceManager = this.getPersistenceManager();
        if (localPersistenceManager != null) {
            Dictionary properties = localPersistenceManager.load(this.getPid());
            String servicePid = (String)properties.get("service.pid");
            if (servicePid != null && !this.getPid().equals(servicePid)) {
                throw new IOException("PID of configuration file does match requested PID; expected " + this.getPid() + ", got " + servicePid);
            }
            this.configureFromPersistence(properties);
            this.getConfigurationManager().updated(this, false);
        }
    }

    public void update(Dictionary properties) throws IOException {
        PersistenceManager localPersistenceManager = this.getPersistenceManager();
        if (localPersistenceManager != null) {
            CaseInsensitiveDictionary newProperties = new CaseInsensitiveDictionary(properties);
            this.setAutoProperties(newProperties, true);
            localPersistenceManager.store(this.getPid(), newProperties);
            String factoryPid = this.getFactoryPid();
            if (factoryPid != null) {
                Factory factory;
                if (this.isNew()) {
                    this.getConfigurationManager().cacheConfiguration(this);
                }
                if ((factory = this.getConfigurationManager().getFactory(factoryPid)).addPID(this.getPid())) {
                    try {
                        factory.store();
                    }
                    catch (IOException ioe) {
                        this.getConfigurationManager().log(1, "Failure storing factory " + factoryPid + " with new configuration " + this.getPid(), ioe);
                    }
                }
            }
            this.configure(newProperties);
            this.getConfigurationManager().updated(this, true);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Configuration) {
            return this.getPid().equals(((Configuration)obj).getPid());
        }
        return false;
    }

    public int hashCode() {
        return this.getPid().hashCode();
    }

    public String toString() {
        return "Configuration PID=" + this.getPid() + ", factoryPID=" + this.factoryPID + ", bundleLocation=" + this.getBundleLocation();
    }

    void store() throws IOException {
        Hashtable props = this.getProperties(false);
        if (props == null) {
            props = new Hashtable();
            this.setAutoProperties(props, true);
        } else {
            ConfigurationImpl.replaceProperty(props, "service.bundleLocation", this.getStaticBundleLocation());
        }
        this.getPersistenceManager().store(this.getPid(), props);
    }

    long getLastModificationTime() {
        return this.lastModificationTime;
    }

    long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    void setLastUpdatedTime() {
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    boolean isNew() {
        return this.properties == null;
    }

    boolean isDeleted() {
        return this.isDeleted;
    }

    private void configureFromPersistence(Dictionary properties) {
        if (properties.get(CONFIGURATION_NEW) == null) {
            this.configure(properties);
        } else {
            this.configure(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(Dictionary properties) {
        CaseInsensitiveDictionary newProperties;
        if (properties == null) {
            newProperties = null;
        } else {
            ConfigurationImpl.clearAutoProperties(properties);
            newProperties = properties instanceof CaseInsensitiveDictionary ? (CaseInsensitiveDictionary)properties : new CaseInsensitiveDictionary(properties);
        }
        ConfigurationImpl configurationImpl = this;
        synchronized (configurationImpl) {
            this.properties = newProperties;
            this.lastModificationTime = System.currentTimeMillis();
        }
    }

    void setAutoProperties(Dictionary properties, boolean withBundleLocation) {
        ConfigurationImpl.replaceProperty(properties, "service.pid", this.getPid());
        ConfigurationImpl.replaceProperty(properties, "service.factoryPid", this.factoryPID);
        if (withBundleLocation) {
            ConfigurationImpl.replaceProperty(properties, "service.bundleLocation", this.getStaticBundleLocation());
        } else {
            properties.remove("service.bundleLocation");
        }
    }

    static void clearAutoProperties(Dictionary properties) {
        properties.remove("service.pid");
        properties.remove("service.factoryPid");
        properties.remove("service.bundleLocation");
    }
}

