/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.equinox.internal.region.StandardRegionDigraph;
import org.eclipse.equinox.internal.region.StandardRegionDigraphPersistence;
import org.eclipse.equinox.internal.region.management.StandardManageableRegionDigraph;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;

public final class RegionManager
implements BundleActivator {
    private static final String REGION_KERNEL = "org.eclipse.equinox.region.kernel";
    private static final String REGION_DOMAIN_PROP = "org.eclipse.equinox.region.domain";
    private static final String DIGRAPH_FILE = "digraph";
    Collection<ServiceRegistration<?>> registrations = new ArrayList();
    private BundleContext bundleContext;
    private final ThreadLocal<Region> threadLocal = new ThreadLocal();
    private String domain;
    private RegionDigraph digraph;
    private StandardManageableRegionDigraph digraphMBean;

    public void start(BundleContext bc) throws BundleException, IOException, InvalidSyntaxException {
        this.bundleContext = bc;
        this.domain = bc.getProperty(REGION_DOMAIN_PROP);
        if (this.domain == null) {
            this.domain = REGION_DOMAIN_PROP;
        }
        this.digraph = this.loadRegionDigraph();
        this.registerRegionHooks(this.digraph);
        this.digraphMBean = this.registerDigraphMbean(this.digraph);
        this.registerRegionDigraph(this.digraph);
    }

    public void stop(BundleContext bc) throws IOException {
        this.digraphMBean.unregisterMbean();
        for (ServiceRegistration<?> registration : this.registrations) {
            registration.unregister();
        }
        this.saveDigraph();
    }

    private RegionDigraph loadRegionDigraph() throws BundleException, IOException, InvalidSyntaxException {
        RegionDigraph regionDigraph;
        File digraphFile = this.bundleContext.getDataFile(DIGRAPH_FILE);
        if (digraphFile == null || !digraphFile.exists()) {
            return this.createRegionDigraph();
        }
        FileInputStream in = new FileInputStream(digraphFile);
        try {
            regionDigraph = StandardRegionDigraphPersistence.readRegionDigraph(new DataInputStream(in), this.bundleContext, this.threadLocal);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return regionDigraph;
    }

    private RegionDigraph createRegionDigraph() throws BundleException {
        StandardRegionDigraph regionDigraph = new StandardRegionDigraph(this.bundleContext, this.threadLocal);
        Region kernelRegion = regionDigraph.createRegion(REGION_KERNEL);
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            kernelRegion.addBundle(bundle);
            ++n2;
        }
        return regionDigraph;
    }

    private void saveDigraph() throws IOException {
        FileOutputStream digraphFile = new FileOutputStream(this.bundleContext.getDataFile(DIGRAPH_FILE));
        try {
            this.digraph.getRegionDigraphPersistence().save(this.digraph, digraphFile);
        }
        catch (Throwable throwable) {
            try {
                digraphFile.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            digraphFile.close();
        }
        catch (IOException iOException) {}
    }

    private StandardManageableRegionDigraph registerDigraphMbean(RegionDigraph regionDigraph) {
        StandardManageableRegionDigraph standardManageableRegionDigraph = new StandardManageableRegionDigraph(regionDigraph, this.domain, this.bundleContext);
        standardManageableRegionDigraph.registerMBean();
        return standardManageableRegionDigraph;
    }

    private void registerRegionHooks(RegionDigraph regionDigraph) {
        this.registerResolverHookFactory(regionDigraph.getResolverHookFactory());
        this.registerBundleFindHook(regionDigraph.getBundleFindHook());
        this.registerBundleEventHook(regionDigraph.getBundleEventHook());
        this.registerServiceFindHook(regionDigraph.getServiceFindHook());
        this.registerServiceEventHook(regionDigraph.getServiceEventHook());
    }

    private void registerRegionDigraph(RegionDigraph regionDigraph) {
        this.registrations.add(this.bundleContext.registerService(RegionDigraph.class, (Object)regionDigraph, null));
    }

    private void registerServiceFindHook(FindHook serviceFindHook) {
        this.registrations.add(this.bundleContext.registerService(FindHook.class, (Object)serviceFindHook, null));
    }

    private void registerServiceEventHook(EventHook serviceEventHook) {
        this.registrations.add(this.bundleContext.registerService(EventHook.class, (Object)serviceEventHook, null));
    }

    private void registerBundleFindHook(org.osgi.framework.hooks.bundle.FindHook findHook) {
        this.registrations.add(this.bundleContext.registerService(org.osgi.framework.hooks.bundle.FindHook.class, (Object)findHook, null));
    }

    private void registerBundleEventHook(org.osgi.framework.hooks.bundle.EventHook eventHook) {
        this.registrations.add(this.bundleContext.registerService(org.osgi.framework.hooks.bundle.EventHook.class, (Object)eventHook, null));
    }

    private void registerResolverHookFactory(ResolverHookFactory resolverHookFactory) {
        this.registrations.add(this.bundleContext.registerService(ResolverHookFactory.class, (Object)resolverHookFactory, null));
    }
}

