/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.build.p2tools.instructions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureParser
extends DefaultHandler {
    private ArrayList<String> result;
    private final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;

    public FeatureParser() {
        try {
            this.parser = this.parserFactory.newSAXParser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("plugin".equals(qName)) {
            this.processAutostart(attributes);
        }
    }

    public ArrayList<String> parse(File featureXml) throws IOException {
        this.result = new ArrayList();
        if (featureXml.exists()) {
            InputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(featureXml));
                    this.parser.parse(input, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    input.close();
                }
            }
            finally {
                input.close();
            }
            return this.result;
        }
        return null;
    }

    private void processAutostart(Attributes attributes) {
        if (attributes.getValue("autostart") != null && attributes.getValue("autostart").equals("true")) {
            this.result.add(attributes.getValue("id"));
        }
    }
}

