/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.virgo.ide.par.Par;
import org.eclipse.virgo.ide.par.provider.ParItemProviderAdapterFactory;
import org.eclipse.virgo.ide.ui.ServerIdeUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParEditor
extends SharedHeaderFormEditor
implements ISelectionProvider {
    public static final String EDITOR_ID = "org.eclipse.virgo.ide.par.ui.editor";
    protected ComposedAdapterFactory adapterFactory;
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected Viewer currentViewer;
    protected ViewerPane currentViewerPane;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof ContentOutline) {
                if (((ContentOutline)part).getCurrentPage() == ParEditor.this.contentOutlinePage) {
                    ParEditor.this.setCurrentViewer((Viewer)ParEditor.this.contentOutlineViewer);
                }
            } else if (part == ParEditor.this) {
                ParEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected Collection<Resource> changedResources = new ArrayList<Resource>();
                    protected Collection<Resource> removedResources = new ArrayList<Resource>();
                    protected ResourceSet resourceSet;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).ParEditor.this.editingDomain.getResourceSet();
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getFlags() != 131072 && delta.getResource().getType() == 1 && (delta.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)delta.getFullPath().toString()), false)) != null) {
                            if ((delta.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else if (!(this).ParEditor.this.savedResources.remove(resource)) {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    ParEditor.this.removedResources.addAll(visitor.getRemovedResources());
                    if (!ParEditor.this.isDirty()) {
                        ParEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ParEditor.this.getSite().getPage().closeEditor((IEditorPart)ParEditor.this, false);
                                ParEditor.this.dispose();
                            }
                        });
                    }
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    ParEditor.this.changedResources.addAll(visitor.getChangedResources());
                    if (ParEditor.this.getSite().getPage().getActiveEditor() == ParEditor.this) {
                        ParEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ParEditor.this.handleActivate();
                            }
                        });
                    }
                }
            }
            catch (CoreException exception) {
                ServerIdeUiPlugin.getDefault().log((Exception)((Object)exception));
            }
        }
    };
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private Resource parResource;
    private Par par;

    public ParEditor() {
        this.initializeEditingDomain();
    }

    protected void addPages() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        try {
            this.parResource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            ServerIdeUiPlugin.getDefault().log(e);
            this.parResource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        this.par = (Par)this.parResource.getContents().iterator().next();
    }

    public void createPages() {
        this.createModel();
        this.addPages();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : ParEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !ParEditor.this.isPersisted(resource) || ParEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        ParEditor.this.savedResources.add(resource);
                        resource.save(saveOptions);
                    }
                    catch (IOException exception) {
                        ParEditor.this.handleError(exception);
                    }
                    first = false;
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            ServerIdeUiPlugin.getDefault().log(exception);
        }
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        return super.getAdapter(key);
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    ParEditor.this.contentOutlineViewer = this.getTreeViewer();
                    ParEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    ParEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)ParEditor.this.adapterFactory));
                    ParEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)ParEditor.this.adapterFactory));
                    ParEditor.this.contentOutlineViewer.setInput((Object)ParEditor.this.parResource);
                    ParEditor.this.createContextMenuFor((StructuredViewer)ParEditor.this.contentOutlineViewer);
                    if (!ParEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        ParEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(ParEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    ParEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ParEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Par getPar() {
        return this.par;
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException exception) {
            ServerIdeUiPlugin.getDefault().log((Exception)((Object)exception));
        }
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.editingDomain.getCommandStack().flush();
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    this.handleError(exception);
                }
            }
        }
    }

    public void handleContentOutlineSelection(ISelection selection) {
        if (this.currentViewerPane != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            Iterator selectedElements = ((IStructuredSelection)selection).iterator();
            selectedElements.hasNext();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"File changed detected", (String)"The file has changed on disk. Discard changes and reload?");
    }

    private void handleError(IOException exception) {
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ParItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                ParEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ParEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            ParEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        ParEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public void setFocus() {
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (ParEditor.this.currentViewer != null) {
                        ParEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    protected boolean showOutlineView() {
        return true;
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(ServerIdeUiPlugin.getDefault().getFormColors(display));
    }
}

