/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.manifest.internal.core.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCoreMessages;
import org.eclipse.virgo.ide.manifest.internal.core.model.AbstractManifestElement;
import org.eclipse.virgo.ide.manifest.internal.core.model.BundleManifestHeader;

public class BundleManifest
extends AbstractManifestElement {
    private static final int BUNDLE_MANIFEST_TYPE = 1;
    private final IFile file;
    private Map<String, BundleManifestHeader> headerMap;
    private IDocument textDocument;

    public BundleManifest(IFile file) {
        super(null, file.getName());
        this.file = file;
        this.init();
    }

    public IDocument getDocument() {
        return this.textDocument;
    }

    public AbstractManifestElement[] getChildren() {
        ArrayList<BundleManifestHeader> headers = new ArrayList<BundleManifestHeader>(this.headerMap.values());
        Collections.sort(headers, new Comparator<BundleManifestHeader>(){

            @Override
            public int compare(BundleManifestHeader o1, BundleManifestHeader o2) {
                return new Integer(o1.getLineNumber()).compareTo(new Integer(o2.getLineNumber()));
            }
        });
        return headers.toArray(new BundleManifestHeader[this.headerMap.size()]);
    }

    public IResource getElementResource() {
        return this.file;
    }

    public int getElementType() {
        return 1;
    }

    public BundleManifestHeader getHeader(String key) {
        return this.headerMap.get(key.toLowerCase());
    }

    public boolean isElementArchived() {
        return false;
    }

    public boolean isExternal() {
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.file.getLocation().toString()).append("\n");
        AbstractManifestElement[] abstractManifestElementArray = this.getChildren();
        int n = abstractManifestElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractManifestElement element = abstractManifestElementArray[n2];
            builder.append(element.toString()).append("\n");
            ++n2;
        }
        return builder.toString();
    }

    private String getHeaderName(String line) {
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == ':') {
                return line.substring(0, i);
            }
            if (!(c >= 'A' && 'Z' >= c || c >= 'a' && 'z' >= c || c >= '0' && '9' >= c)) {
                if (i == 0) {
                    return null;
                }
                if (c != '-' && c != '_') {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    protected IDocument createDocument(IFile file) {
        if (!file.exists()) {
            return null;
        }
        try {
            String contents = this.convertStreamToString(file.getContents(true));
            return new Document(contents);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected void error(int severity, String message, int line) {
    }

    protected void init() {
        this.textDocument = this.createDocument(this.file);
        this.parseManifest(this.textDocument);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseManifest(IDocument document) {
        try {
            String line;
            IRegion lineInfo;
            this.headerMap = new HashMap<String, BundleManifestHeader>();
            AbstractManifestElement header = null;
            int l = 0;
            while (l < document.getNumberOfLines()) {
                ByteBuffer byteBuf;
                lineInfo = document.getLineInformation(l);
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                Charset charset = Charset.forName("UTF-8");
                String lineDelimiter = document.getLineDelimiter(l);
                if (lineDelimiter == null) {
                    lineDelimiter = "";
                }
                if ((byteBuf = charset.encode(line)).limit() + lineDelimiter.length() > 512) {
                    this.error(2, BundleManifestCoreMessages.BundleErrorReporter_lineTooLong, l + 1);
                    return;
                }
                if (line.length() == 0) {
                    if (l == 0) {
                        this.error(2, BundleManifestCoreMessages.BundleErrorReporter_noMainSection, 1);
                        return;
                    }
                    if (header == null) break;
                    this.headerMap.put(header.getName().toLowerCase(), (BundleManifestHeader)header);
                    header = null;
                    break;
                }
                if (line.charAt(0) == ' ') {
                    if (l == 0) {
                        this.error(2, BundleManifestCoreMessages.BundleErrorReporter_noMainSection, 1);
                        return;
                    }
                    if (header != null) {
                        ((BundleManifestHeader)header).append(line.substring(1));
                    }
                } else {
                    int colon;
                    if (header != null) {
                        this.headerMap.put(header.getName().toLowerCase(), (BundleManifestHeader)header);
                        header = null;
                    }
                    if ((colon = line.indexOf(58)) == -1) {
                        this.error(2, BundleManifestCoreMessages.BundleErrorReporter_noColon, l + 1);
                        return;
                    }
                    String headerName = this.getHeaderName(line);
                    if (headerName == null) {
                        this.error(2, BundleManifestCoreMessages.BundleErrorReporter_invalidHeaderName, l + 1);
                        return;
                    }
                    if (line.length() < colon + 2 || line.charAt(colon + 1) != ' ') {
                        this.error(2, BundleManifestCoreMessages.BundleErrorReporter_noSpaceValue, l + 1);
                        return;
                    }
                    if ("Name".equals(headerName)) {
                        this.error(2, BundleManifestCoreMessages.BundleErrorReporter_nameHeaderInMain, l + 1);
                        return;
                    }
                    header = new BundleManifestHeader(this, headerName, line.substring(colon + 2), l);
                    if (this.headerMap.containsKey(header.getName().toLowerCase())) {
                        this.error(1, BundleManifestCoreMessages.BundleErrorReporter_duplicateHeader, l + 1);
                    }
                }
                ++l;
            }
            if (header != null) {
                this.error(2, BundleManifestCoreMessages.BundleErrorReporter_noLineTermination, l + 1);
                return;
            }
            while (true) {
                if (l >= document.getNumberOfLines()) {
                    return;
                }
                lineInfo = document.getLineInformation(l);
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                if (line.length() != 0) {
                    if (line.startsWith("Name:")) return;
                    this.error(2, BundleManifestCoreMessages.BundleErrorReporter_noNameHeader, l);
                    return;
                }
                ++l;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block12: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuilder();
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException iOException) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException2) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }
}

