/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.facet.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.facet.internal.core.Plan;
import org.eclipse.virgo.ide.facet.internal.core.PlanReader;
import org.eclipse.virgo.ide.facet.internal.core.PlanReference;
import org.eclipse.virgo.ide.par.Bundle;
import org.eclipse.virgo.ide.par.Par;
import org.eclipse.virgo.ide.par.ParPackage;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetUtils {
    public static boolean isBundleProject(IResource resource) {
        return FacetUtils.hasNature(resource, "org.eclipse.jdt.core.javanature") && FacetUtils.hasProjectFacet(resource, "org.eclipse.virgo.server.bundle");
    }

    public static boolean isParProject(IResource resource) {
        return FacetUtils.hasProjectFacet(resource, "org.eclipse.virgo.server.par");
    }

    public static boolean isPlanProject(IResource resource) {
        return FacetUtils.hasProjectFacet(resource, "org.eclipse.virgo.server.plan");
    }

    public static boolean hasProjectFacet(IResource resource, String facetId) {
        if (resource != null && resource.isAccessible()) {
            try {
                return FacetedProjectFramework.hasProjectFacet((IProject)resource.getProject(), (String)facetId);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.facet.core", "An error occurred inspecting project facet", (Throwable)e));
            }
        }
        return false;
    }

    public static boolean hasNature(IResource resource, String natureId) {
        IProject project;
        if (resource != null && resource.isAccessible() && (project = resource.getProject()) != null) {
            try {
                return project.hasNature(natureId);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.facet.core", "An error occurred inspecting project nature", (Throwable)e));
            }
        }
        return false;
    }

    public static IProject[] getBundleProjects() {
        IProject[] projects;
        ArrayList<IProject> bundles = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject candidate = iProjectArray[n2];
            if (FacetUtils.isBundleProject((IResource)candidate)) {
                bundles.add(candidate);
            }
            ++n2;
        }
        return bundles.toArray(new IProject[bundles.size()]);
    }

    public static IProject[] getParProjects(IProject project) {
        IProject[] projects;
        HashSet<IProject> bundles = new HashSet<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject candidate = iProjectArray[n2];
            if (FacetUtils.isParProject((IResource)candidate) && Arrays.asList(FacetUtils.getBundleProjects(candidate)).contains(project)) {
                bundles.add(candidate);
            }
            ++n2;
        }
        return bundles.toArray(new IProject[bundles.size()]);
    }

    public static IProject[] getBundleProjects(IProject parProject) {
        Par par;
        HashSet<IProject> bundles = new HashSet<IProject>();
        if (FacetUtils.isParProject((IResource)parProject) && (par = FacetUtils.getParDefinition(parProject)) != null && par.getBundle() != null) {
            for (Bundle bundle : par.getBundle()) {
                IProject bundleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(bundle.getSymbolicName());
                if (!FacetUtils.isBundleProject((IResource)bundleProject)) continue;
                bundles.add(bundleProject);
            }
        }
        return bundles.toArray(new IProject[bundles.size()]);
    }

    public static Par getParDefinition(IProject project) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://eclipse.org/virgo/par.ecore", (Object)ParPackage.eINSTANCE);
        File parFile = new File(new File(String.valueOf(project.getLocation().toString()) + File.separatorChar + ".settings"), "org.eclipse.virgo.ide.runtime.core.par.xml");
        if (parFile.exists()) {
            Resource resource;
            block7: {
                URI fileUri = URI.createFileURI((String)parFile.toString());
                resource = null;
                try {
                    resource = resourceSet.getResource(fileUri, true);
                }
                catch (WrappedException e) {
                    if (!(e.getCause() instanceof PackageNotFoundException)) break block7;
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(parFile));
                        StringBuilder sb = new StringBuilder();
                        String next = br.readLine();
                        do {
                            next = next.replaceAll("http:///com/springsource/server/ide/par.ecore", "http://eclipse.org/virgo/par.ecore");
                            next = next.replaceAll("com\\.springsource\\.server", "org.eclipse.virgo");
                            sb.append(String.valueOf(next) + "\n");
                        } while ((next = br.readLine()) != null);
                        br.close();
                        BufferedWriter bw = new BufferedWriter(new FileWriter(parFile));
                        bw.write(sb.toString());
                        bw.close();
                        project.refreshLocal(2, null);
                        resource = resourceSet.getResource(fileUri, true);
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                    catch (CoreException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            return (Par)resource.getContents().iterator().next();
        }
        return null;
    }

    public static IFile getParFile(IProject project) {
        IResource resource = project.findMember(new Path(".settings").append("org.eclipse.virgo.ide.runtime.core.par.xml"));
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public static Collection<IFile> getPlansInPlanProject(IProject project) {
        if (!FacetUtils.isPlanProject((IResource)project)) {
            return Collections.emptyList();
        }
        final ArrayList<IFile> planFiles = new ArrayList<IFile>();
        final HashSet<IPath> outputLocations = new HashSet<IPath>();
        try {
            if (FacetUtils.hasNature((IResource)project, "org.eclipse.jdt.core.javanature")) {
                IJavaProject je = JavaCore.create((IProject)project);
                try {
                    outputLocations.add(je.getOutputLocation());
                    IClasspathEntry[] iClasspathEntryArray = je.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 3 && entry.getOutputLocation() != null) {
                            outputLocations.add(entry.getOutputLocation());
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.isTeamPrivateMember() || resource.isDerived()) {
                        return false;
                    }
                    if (resource instanceof IFile && "plan".equals(resource.getFileExtension())) {
                        planFiles.add((IFile)resource);
                    } else if (resource instanceof IContainer) {
                        IPath path = ((IContainer)resource).getFullPath();
                        for (IPath outputLocation : outputLocations) {
                            if (!outputLocation.isPrefixOf(path)) continue;
                            return false;
                        }
                        return true;
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {}
        return planFiles;
    }

    private static Map<IProject, Collection<IFile>> getPlansInWorkspace() {
        IProject[] projects;
        HashMap<IProject, Collection<IFile>> plans = new HashMap<IProject, Collection<IFile>>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.isOpen() && FacetUtils.isPlanProject((IResource)iProject)) {
                Collection<IFile> ps = FacetUtils.getPlansInPlanProject(iProject);
                plans.put(iProject, ps);
            }
            ++n2;
        }
        return plans;
    }

    public static List<IFile> getNestedPlanFiles(IFile planFile, boolean recurse) {
        Plan topLevelPlan;
        if (!FacetUtils.isPlanProject((IResource)planFile)) {
            return Collections.emptyList();
        }
        PlanReader reader = new PlanReader();
        try {
            topLevelPlan = reader.read(planFile);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
        List<PlanReference> nestedReferences = topLevelPlan.getNestedPlans();
        if (nestedReferences.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IFile> nestedPlanFiles = new ArrayList<IFile>();
        List<IProject> orderedProjects = FacetUtils.getOrderedProjectDependencies(planFile.getProject());
        orderedProjects.add(0, planFile.getProject());
        Map<IProject, Collection<IFile>> allPlans = FacetUtils.getPlansInWorkspace();
        HashMap<String, Plan> name2PlanLookup = new HashMap<String, Plan>();
        HashMap<PlanReference, Plan> ref2Plan = new HashMap<PlanReference, Plan>();
        HashMap<PlanReference, IFile> ref2File = new HashMap<PlanReference, IFile>();
        for (IProject iProject : orderedProjects) {
            Collection<IFile> candidates = allPlans.get(iProject);
            if (candidates == null) continue;
            for (IFile iFile : candidates) {
                if (planFile.equals((Object)iFile)) continue;
                try {
                    Plan p = reader.read(iFile);
                    PlanReference r = p.asRefence();
                    if (ref2Plan.containsKey(r)) continue;
                    ref2Plan.put(r, p);
                    if (!name2PlanLookup.containsKey(r.getName())) {
                        name2PlanLookup.put(r.getName(), p);
                    }
                    ref2File.put(r, iFile);
                }
                catch (Exception exception) {}
            }
        }
        ArrayBlockingQueue<PlanReference> toBeProcessed = new ArrayBlockingQueue<PlanReference>(ref2Plan.size() + 1);
        HashSet<PlanReference> alreadyProcessed = new HashSet<PlanReference>();
        toBeProcessed.addAll(nestedReferences);
        while (toBeProcessed.peek() != null) {
            PlanReference planReference = (PlanReference)toBeProcessed.poll();
            alreadyProcessed.add(planReference);
            Plan nestedPlan = (Plan)ref2Plan.get(planReference);
            if (nestedPlan == null && planReference.getVersion() == null) {
                nestedPlan = (Plan)name2PlanLookup.get(planReference.getName());
            }
            if (nestedPlan == null) continue;
            IFile nestedFile = (IFile)ref2File.get(nestedPlan.asRefence());
            nestedPlanFiles.add(nestedFile);
            for (PlanReference aRef : nestedPlan.getNestedPlans()) {
                if (!recurse || alreadyProcessed.contains(aRef)) continue;
                toBeProcessed.add(aRef);
            }
        }
        return nestedPlanFiles;
    }

    private static List<IProject> getOrderedProjectDependencies(IProject project) {
        LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
        if (FacetUtils.hasNature((IResource)project, "org.eclipse.jdt.core.javanature")) {
            IJavaProject je = JavaCore.create((IProject)project);
            try {
                String[] names;
                String[] stringArray = names = je.getRequiredProjectNames();
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String prjName = stringArray[n2];
                    IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(prjName);
                    if (prj.exists() && prj.isOpen() && FacetUtils.isPlanProject((IResource)prj)) {
                        projects.add(prj);
                        projects.addAll(FacetUtils.getOrderedProjectDependencies(prj));
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return new ArrayList<IProject>(projects);
    }
}

