/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.export;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;

public abstract class AbstractProjectExportWizardPage
extends WizardExportResourcesPage {
    private Button browseButton;
    private Text destinationText;
    protected TableViewer tableViewer;
    protected IStructuredSelection initialSelection;
    private boolean overwrite;

    protected AbstractProjectExportWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.initialSelection = selection;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Label selectProject = new Label(composite, 0);
        selectProject.setText("Select the project to export:");
        selectProject.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createInputGroup(composite);
        this.createDestinationGroup(composite);
        this.setControl((Control)composite);
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    protected void createDestinationGroup(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(destinationSelectionGroup, 0);
        label.setText("Select the export destination:");
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        Label jarLabel = new Label(destinationSelectionGroup, 0);
        jarLabel.setText(this.getDestinationLabel());
        jarLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        this.destinationText = new Text(destinationSelectionGroup, 2048);
        this.destinationText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.destinationText.setEditable(true);
        this.destinationText.addListener(24, (Listener)this);
        this.browseButton = new Button(destinationSelectionGroup, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.setLayoutData((Object)new GridData(4, 4, false, true));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractProjectExportWizardPage.this.handleDestinationBrowseButtonPressed();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractProjectExportWizardPage.this.updateFileName();
            }
        });
        this.updateFileName();
        final Button overwriteButton = new Button(destinationSelectionGroup, 32);
        overwriteButton.setText("Overwrite existing file without warning");
        GridData buttonData = new GridData(4, 4, true, false);
        buttonData.horizontalSpan = 3;
        buttonData.verticalIndent = 5;
        overwriteButton.setLayoutData((Object)buttonData);
        overwriteButton.setSelection(false);
        overwriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractProjectExportWizardPage.this.overwrite = overwriteButton.getSelection();
            }
        });
    }

    protected void updateFileName() {
        IProject project = this.getSelectedProject();
        if (project == null) {
            return;
        }
        BundleManifest manifest = this.getBundleManifest(project);
        if (manifest != null) {
            String name = this.getSymbolicName(manifest);
            String version = this.getVersion(manifest);
            Path path = null;
            path = this.destinationText.getText() != null ? new Path("") : new Path(this.destinationText.getText());
            if (name != null && version != null) {
                path = path.removeLastSegments(1).append(String.valueOf(name) + "-" + version + this.getExtension());
                this.destinationText.setText(path.toOSString());
            }
        }
    }

    protected abstract String getSymbolicName(BundleManifest var1);

    protected abstract String getVersion(BundleManifest var1);

    protected abstract BundleManifest getBundleManifest(IProject var1);

    private void createInputGroup(Composite parent) {
        GridData data = new GridData(4, 4, true, true);
        this.tableViewer = new TableViewer(parent, 2052);
        this.tableViewer.getTable().setLayoutData((Object)data);
        this.tableViewer.setUseHashlookup(true);
        int labelFlags = 272;
        ITreeContentProvider treeContentProvider = this.getTreeContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(labelFlags), (ILabelDecorator)new ProblemsLabelDecorator(null));
        this.tableViewer.setContentProvider((IContentProvider)treeContentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tableViewer.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        this.tableViewer.setComparator((ViewerComparator)new JavaElementComparator());
        this.tableViewer.addFilter(this.getTreeViewerFilter());
        this.tableViewer.setInput(this.getInput());
        this.tableViewer.setSelection((ISelection)new StructuredSelection(this.initialSelection.toArray()), true);
    }

    protected abstract String getDestinationLabel();

    private String getDestinationValue() {
        String destinationString = this.destinationText.getText().trim();
        if (destinationString.indexOf(46) < 0) {
            destinationString = String.valueOf(destinationString) + this.getOutputSuffix();
        }
        return destinationString;
    }

    protected abstract String getExtension();

    protected abstract Object getInput();

    public IPath getJarLocation() {
        return Path.fromOSString((String)this.destinationText.getText());
    }

    private String getOutputSuffix() {
        return ".jar";
    }

    public IProject getSelectedProject() {
        ISelection selection = this.tableViewer.getSelection();
        Object[] selectedItems = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toArray() : new Object[]{};
        Object[] objectArray = selectedItems;
        int n = selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedItem = objectArray[n2];
            if (selectedItem instanceof IJavaProject) {
                return ((IJavaProject)selectedItem).getProject();
            }
            if (selectedItem instanceof IProject) {
                return (IProject)selectedItem;
            }
            ++n2;
        }
        return null;
    }

    protected abstract ITreeContentProvider getTreeContentProvider();

    protected abstract ViewerFilter getTreeViewerFilter();

    private void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*" + this.getExtension()});
        String currentSourceString = this.getDestinationValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
            dialog.setFileName(currentSourceString.substring(lastSeparatorIndex + 1, currentSourceString.length()));
        } else {
            dialog.setFileName(currentSourceString);
        }
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            IContainer[] findContainersForLocation = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation((IPath)new Path(selectedFileName));
            if (findContainersForLocation.length > 0) {
                selectedFileName = findContainersForLocation[0].getFullPath().makeRelative().toString();
            }
            this.destinationText.setText(selectedFileName);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        String text = this.destinationText.getText();
        if (text.length() == 0) {
            this.setErrorMessage(null);
            return false;
        }
        if (!text.endsWith(this.getExtension())) {
            this.setErrorMessage("Export destination must have " + this.getExtension() + " extension.");
            return false;
        }
        if (this.tableViewer.getSelection().isEmpty()) {
            this.setErrorMessage("Bundle project selection must not be empty.");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

