/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFilter;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.handlers.ShowPatternLocationHandler;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * @author Abel Hegedus
 * @since 1.4
 */
@SuppressWarnings("all")
public class ShowMatcherLocationHandler extends ShowPatternLocationHandler {
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    ISelection _currentSelection = HandlerUtil.getCurrentSelection(event);
    final IStructuredSelection selection = ((IStructuredSelection) _currentSelection);
    Object _firstElement = selection.getFirstElement();
    final QueryResultTreeMatcher<?> matcher = ((QueryResultTreeMatcher<?>) _firstElement);
    IQuerySpecificationRegistryEntry _entry = matcher.getEntry();
    boolean _tripleNotEquals = (_entry != null);
    if (_tripleNotEquals) {
      this.showPatternLocation(event, matcher.getEntry());
    } else {
      final String fqn = matcher.getMatcher().getSpecification().getFullyQualifiedName();
      final IRegistryViewFilter _function = (IQuerySpecificationRegistryEntry entry) -> {
        String _fullyQualifiedName = entry.getFullyQualifiedName();
        final boolean fqnRelevant = Objects.equals(fqn, _fullyQualifiedName);
        return fqnRelevant;
      };
      final IRegistryView view = QuerySpecificationRegistry.getInstance().createView(_function);
      final Consumer<IQuerySpecificationRegistryEntry> _function_1 = (IQuerySpecificationRegistryEntry it) -> {
        try {
          this.showPatternLocation(event, it);
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      view.getEntries().forEach(_function_1);
    }
    return null;
  }
}
