/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.transformation.views.traceability.patterns.internal;

import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.transformation.views.traceability.patterns.EmptyTrace;
import org.eclipse.viatra.transformation.views.traceability.patterns.Param2target;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace2object;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace2param;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace2target;

/**
 * A pattern group formed of all patterns defined in helpers.vql.
 * 
 * <p>A private group that includes private patterns as well. Only intended use case is for pattern testing.
 * 
 * <p> From package org.eclipse.viatra.transformation.views.traceability.patterns, the group contains the definition of the following patterns: <ul>
 * <li>emptyTrace</li>
 * <li>traceTargets</li>
 * <li>trace2target</li>
 * <li>trace2param</li>
 * <li>trace2object</li>
 * <li>param2target</li>
 * <li>trace</li>
 * </ul>
 * 
 * @see IQueryGroup
 * 
 */
@SuppressWarnings("all")
public final class HelpersAll extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryRuntimeException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static HelpersAll instance() {
    if (INSTANCE == null) {
        INSTANCE = new HelpersAll();
    }
    return INSTANCE;
  }

  private static HelpersAll INSTANCE;

  private HelpersAll() {
    querySpecifications.add(EmptyTrace.instance());
    querySpecifications.add(TraceTargets.instance());
    querySpecifications.add(Trace2target.instance());
    querySpecifications.add(Trace2param.instance());
    querySpecifications.add(Trace2object.instance());
    querySpecifications.add(Param2target.instance());
    querySpecifications.add(Trace.instance());
  }
}
