/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;

public class ExtendToEStructuralFeatureSource
implements ISearchOperation {
    private int targetPosition;
    private EStructuralFeature feature;
    private int sourcePosition;

    public ExtendToEStructuralFeatureSource(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(-" + variableMapping.apply(this.sourcePosition) + ", +" + variableMapping.apply(this.targetPosition) + ") iterating";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.sourcePosition, this.targetPosition);
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<Object> {
        private Executor() {
            super(ExtendToEStructuralFeatureSource.this.sourcePosition);
        }

        @Override
        public Iterator<?> getIterator(MatchingFrame frame, ISearchContext context) {
            if (!(ExtendToEStructuralFeatureSource.this.feature instanceof EReference)) {
                throw new LocalSearchException("Without base index, inverse navigation only possible along EReferences with defined EOpposite.");
            }
            EReference oppositeFeature = ((EReference)ExtendToEStructuralFeatureSource.this.feature).getEOpposite();
            if (oppositeFeature == null) {
                throw new LocalSearchException("Feature has no EOpposite, so cannot do inverse navigation " + ExtendToEStructuralFeatureSource.this.feature.toString());
            }
            try {
                EObject value = (EObject)frame.getValue(ExtendToEStructuralFeatureSource.this.targetPosition);
                if (!oppositeFeature.getEContainingClass().isSuperTypeOf(value.eClass())) {
                    return Collections.emptyIterator();
                }
                Object featureValue = value.eGet((EStructuralFeature)oppositeFeature);
                if (oppositeFeature.isMany()) {
                    if (featureValue != null) {
                        Collection objectCollection = (Collection)featureValue;
                        return objectCollection.iterator();
                    }
                    return Collections.emptyIterator();
                }
                if (featureValue != null) {
                    return Collections.singleton(featureValue).iterator();
                }
                return Collections.emptyIterator();
            }
            catch (ClassCastException e) {
                throw new LocalSearchException("Invalid feature target in parameter" + Integer.toString(ExtendToEStructuralFeatureSource.this.targetPosition), e);
            }
        }

        @Override
        public ISearchOperation getOperation() {
            return ExtendToEStructuralFeatureSource.this;
        }
    }
}

